/*
 * getword.c - getword() and related functions
 */

#include <stdio.h>
#include <string.h>

char word[200];

static int hit_eof = 0;
static char line[200];
static char *lp;

void
init_getword (void)
{
  char *s;

  if (gets (line) == NULL)
    {
      hit_eof = 1;
      return;
    }
  if ((s = strchr (line, '#')) != NULL)
    *s = '\0';
  lp = line;
}

int
getword (void)
{
  char *s;

  s = word;
  while (*lp == ' ' || *lp == '\t')
    lp++;
  while (*lp == '\0')
    {
      init_getword ();
      if (hit_eof)
	return 1;
      while (*lp == ' ' || *lp == '\t')
	lp++;
    }
  while (*lp != ' ' && *lp != '\t' && *lp != '\0')
    *s++ = *lp++;
  *s = '\0';
  return 0;
}

int
getint (void)
{
  int i;

  if (getword ())
    return 0;
  if (sscanf (word, "%d", &i) < 1)
    i = 0;
  return i;
}

double
getdouble (void)
{
  double x;

  if (getword ())
    return 0.0;
  if (sscanf (word, "%lf", &x) < 1)
    x = 0.0;
  return x;
}
