/*
 * Code to test atom.C
 */

#include <stdio.h>
#include <malloc.h>

#include "atom.h"
#include "bond.h"
#include "term.h"
#include "group.h"

#define X 0.076
#define DT 1.0E-6

int
main (int argc, char *argv[])
{
  double t;
  int i;
  group *g;
  atom *a1, *a2;
  term *t1, *t2, *t3;

  a1 = malloc (sizeof (atom));
  a2 = malloc (sizeof (atom));
  t1 = malloc (sizeof (term));
  t2 = malloc (sizeof (term));
  t3 = malloc (sizeof (atom));
  g = malloc (sizeof (group));

  if (argc > 2)
    {
      init_atom (a1, C_SP3, 1.0, -X, 0.0, 0.0);
      init_atom (a2, C_SP3, 1.0, X, 0.0, 0.0);
    }
  else
    {
      init_atom (a1, C_SP3, 0.0, -X, 0.0, 0.0);
      init_atom (a2, C_SP3, 0.0, X, 0.0, 0.0);
    }
  length_term (t1, a1, a2);
  spring_damper_term (t2, a1, a2, 2.0e4, 0.3, 100.0);
  electrostatic_term (t3, a1, a2);

  add_atom (g, a1);
  add_atom (g, a2);
  add_term (g, t1);
  add_term (g, t2);
  add_term (g, t3);

  for (t = 0.0, i = 0; t < 1.0 + 0.1 * DT; t += DT, i++)
    {
      physics_time_step (g, DT);
      /* if you want to apply external forces, do that now */

      if (argc > 1)
	if ((i % ((int) (0.01 / DT))) == 0)
	  printf ("%f %f %f %f\n", t, a1->x[0], a2->x[0], energy (g));
    }

  free (a1);
  free (a2);
  free (t1);
  free (t2);
  free (t3);
  free (g);
}
