/*
 *  Energy/force terms
 */

enum TERMTYPE
{
  LENGTH, ANGLE, TORSION, VDW, ELECTROSTATIC, SPRING_DAMPER,
  INVALID
};

class term
{
 public:
  enum TERMTYPE type;
  struct atom *atoms[4];
  double coeffs[4];
  term () { type = INVALID; }
  double energy_function ();
  void add_forces ();
};

term *length_term (atom * a1, atom * a2);
term *angle_term (atom * a1, atom * a2, atom * a3);
term *torsion_term (atom * a1, atom * a2, atom * a3, atom * a4);
term *vdw_term (atom * a1, atom * a2);
term *electrostatic_term (atom * a1, atom * a2);
term *spring_damper_term (atom * a1, atom * a2, double k, double r0, double d);
