/*
 *  Energy/force terms
 */

#ifndef TERM_H
#define TERM_H

enum TERMTYPE
  {
    LENGTH, ANGLE, TORSION, VDW, ELECTROSTATIC, SPRING_DAMPER,
    INVALID
  };

typedef struct
  {
    enum TERMTYPE type;
    atom *atoms[4];
    double coeffs[4];
  }
term;

extern double term_energy (term * t);
extern void term_add_forces (term * t);
extern void length_term (term * t, atom * a1, atom * a2);
extern void angle_term (term * t, atom * a1, atom * a2, atom * a3);
extern void torsion_term (term * t, atom * a1, atom * a2,
			  atom * a3, atom * a4);
extern void vdw_term (term * t, atom * a1, atom * a2);
extern void electrostatic_term (term * t, atom * a1, atom * a2);
extern void spring_damper_term (term * t, atom * a1, atom * a2,
				double k, double r0, double d);

#endif
