/*****
This file is part of the Babel Program
Copyright (C) 1992-94 W. Patrick Walters and Matthew T. Stahl
The Babel Program is a product of the Dolata Research Group
Dept. of Chemistry
University of Arizona
Tucson, AZ 85721

For more information please contact :

babel@mercury.aichem.arizona.edu
--------------------------------------------------------------------------------

FILE : rdxyz.c
AUTHOR(S) : Pat Walters -> modified by A. Parrill so bonds are not assigned
DATE : 10-92
PURPOSE : routines to read the XYZ format used by the Xmol program from MSC
	
MODIFIED : 10-16-93 to allow the use of multistructure files
MODIFIED : 7-11-94 so that bonds will not be assigned - for use in reading
           feature file generated by Clew's perception routines
******/


#include "bbltyp.h"

int 
read_feat(FILE *file1, ums_type *mol)
{
  char the_line[BUFF_SIZE];
  int i;

  fgets(the_line,sizeof(the_line),file1);
  sscanf(the_line,"%d",&Atoms);

#ifdef MAC
ShowProgress(Atoms,"Reading Atoms");
#endif

  initialize_ums(&mol);
  fgets(the_line,sizeof(the_line),file1);
  strcpy(Title, the_line);

  for (i = MIN_ATOM; i <= Atoms;i ++)
  {
#ifdef MAC
      UpdateProgress();
#endif
      fgets(the_line,sizeof(the_line), file1);
      sscanf(the_line,"%s %lf %lf %lf",
	     Type(i),
	     &X(i),
	     &Y(i),
	     &Z(i));
      clean_atom_type(Type(i));
    }

  return(TRUE);
}




