/*****
This file is part of the Babel Program
Copyright (C) 1992-93 Arizona Board of Regents for the AI in Chemistry Lab
The Babel Program is a product of the Dolata Research Group
Dept. of Chemistry
University of Arizona
Tucson, AZ 85721

For more information please contact :

babel@mercury.aichem.arizona.edu
--------------------------------------------------------------------------------

FILE : rdisis.c
AUTHOR(S) : Pat Walters
DATE : 1-6-94
PURPOSE : routines to read an MDL isis file

******/

#include "bbltyp.h"

int 
read_isis(FILE *file1, ums_type *mol)
{
  char the_line[BUFF_SIZE];
  int i;
  int result;
  char temp[15];

  while (!check_for_eof(file1)) {
    fgets(the_line,sizeof(the_line),file1);
    my_strncpy(temp,the_line,8);
    if (strncmp(temp,"  -ISIS-",8) == 0)
      break;
  }
  fgets(the_line,sizeof(the_line),file1);
/* End of changes ... Ajay, Nov. 17 1994! */

  fgets(the_line,sizeof(the_line),file1);
  my_strncpy(temp,the_line,3);
  Atoms = atoi(temp);
  my_strncpy(temp,&the_line[3],3);
  Bonds = atoi(temp);
  ShowProgress(Atoms,"Reading Atoms");
  result = initialize_ums(&mol);
  for (i = MIN_ATOM; i <= Atoms; i++)
    {
      UpdateProgress();
      fgets(the_line,sizeof(the_line),file1);
      my_strncpy(temp,the_line,10);
      X(i) = atof(temp);
      my_strncpy(temp,&the_line[10],10);
      Y(i) = atof(temp);
      my_strncpy(temp,&the_line[20],10);
      Z(i) = atof(temp);
      my_strncpy(Type(i),&the_line[31],2);
      clean_atom_type(Type(i));
    }
  ShowProgress(Atoms,"Reading Atoms");
  for (i = 0; i < Bonds; i++)
    {
      UpdateProgress();
      fgets(the_line,sizeof(the_line),file1);
      my_strncpy(temp,the_line,3);
      Start(i) = atoi(temp);
      my_strncpy(temp,&the_line[3],3);
      End(i) = atoi(temp);
      my_strncpy(temp,&the_line[6],3);
      Bond_order(i) = atoi(temp);
    }
/* 
  The following line has been added to finish reading the molecule.
  That is, read till "$$$$" line. Ajay ... Nov. 17, 1994
*/
    while (!check_for_eof(file1)) {
    fgets(the_line,sizeof(the_line),file1);
    my_strncpy(temp,the_line,4);
    if (strncmp(temp,"$$$$",4) == 0)
      break;
  }

  if (strstr(InputKeywords,"scale"))
      scale_for_ChemWindow(mol);
  dissect_connection_table(mol);
  result = assign_types(mol);
  return(TRUE);
}


  

 



   
    
    
    
	  


