/*****
This file is part of the Babel Program
Copyright (C) 1992-94 W. Patrick Walters and Matthew T. Stahl
The Babel Program is a product of the Dolata Research Group
Dept. of Chemistry
University of Arizona
Tucson, AZ 85721

For more information please contact :

babel@mercury.aichem.arizona.edu
--------------------------------------------------------------------------------

FILE : rdmaccs.c
AUTHOR(S) : Matthew Stahl
DATE : 10-92
PURPOSE : routines to read the MACCS format
	
******/


#include "bbltyp.h"

static warning wstr;

int 
read_maccs2d(FILE *file1, ums_type *mol)
{
  char the_line[BUFF_SIZE];
  int i;
  int charge;
  long int prev,pos;
  double dummyd;
  int dummyi;
  char dummyc[100];

  prev = ftell(file1);
  do
  {
    fgets(the_line,sizeof(the_line),file1);
    if  (sscanf(the_line,"%lf%lf%lf%s%d%d%d%d%d%d",
	   &dummyd,&dummyd,&dummyd,dummyc,
	   &dummyi,&dummyi,&dummyi,&dummyi,&dummyi,&dummyi) == 10)
      break;
    prev = pos;
    pos = ftell(file1);
  } while (!check_for_eof(file1));

  if (check_for_eof(file1))
    fatal_error("Unable to find beginning of file");

  fseek(file1,prev,0);
  fgets(the_line,sizeof(the_line),file1);
  if (sscanf(the_line,"%d %d",&Atoms,&Bonds) != 2)
    fatal_error("Unable to find beginning of file");

  ShowProgress(Atoms,"Reading Atoms");
  initialize_ums(&mol);

  for (i = MIN_ATOM; i <= Atoms; i++)
  {
    UpdateProgress();
    fgets(the_line,sizeof(the_line), file1);
    sscanf(the_line,"%lf %lf %lf %s %*d %d",
	   &X(i),
	   &Y(i),
	   &Z(i),
	   Type(i),&charge);
    Charge(i) = (int) charge;
    clean_atom_type(Type(i));
  }

  for (i = MIN_ATOM; i <= Atoms; i++)
    switch ((int) Charge(i))
    {
    case 1:
      Charge(i) = 3.0;
      break;
    case 2:
      Charge(i) = 2.0;
      break;
    case 3:
      Charge(i) = 1.0;
      break;
    case 5:
      Charge(i) = -1.0;
      break;
    case 6:
      Charge(i) = -2.0;
      break;
    case 7:
      Charge(i) = -3.0;
      break;
    }
  
  for(i = 0;i < Bonds;i++)
  {
    fgets(the_line,sizeof(the_line), file1);
    sscanf(the_line,"%d %d %d",&Start(i),&End(i),&Bond_order(i));
  }

  dissect_connection_table(mol); 
  assign_type_by_bo(mol);
  add_2d_hydrogens(mol);
  
  while (fgets(the_line,sizeof(the_line),file1))
    if (EQn(the_line,"$$$$",4))
      break;
    
  return(TRUE);
}

void
  assign_type_by_bo(ums_type *mol)
{
  int i,j,k;
  int max_order;

  for (i = 1;i <= Atoms;i++)
  {
    max_order = 0;
    for (j = 0;j < Valence(i);j++)
      if (BO(i,j) > max_order)
	  max_order = BO(i,j);

    if (!strstr("Fe F Br I",Type(i)) && NOTEQ(Type(i),"Cl"))
      switch (Type(i)[0])
      {
      case 'C':
      case 'N':
      case 'S':
      case 'P':
      case 'O':
	
	switch (max_order)
	{
	case 1:
	  strcat(Type(i),"3");
	  break;
	case 5:
	case 2:
	  strcat(Type(i),"2");
	  break;
	case 3:
	  strcat(Type(i),"1");
	  break;	
	}
      }
  }

  for (i = 1;i <= Atoms;i++)
    if (EQn(Type(i),"N3",2) && Valence(i) < 4)
    {
      for (j = 0;j < Valence(i);j++)
	if (Type(Connection(i,j))[0] == 2)
	  strcpy(Type(i),"N2");
    }

  for (i = 1;i <= Atoms;i++)
  { 
    if (Charge(i) != 0.0)
    {
      if (Type(i)[0] == 'O' && Charge(i) == -1.0)
      {
	clean_atom_type(Type(i));
	strcat(Type(i),"-");
      }

      if (Type(i)[0] == 'N' && Charge(i) == 1.0)
	strcat(Type(i),"+");
    }

    if (EQ(Type(i),"S2") && Valence(i) > 3)
      strcpy(Type(i),"S3");

    if (EQ(Type(i),"P2") && Valence(i) > 3)
      strcpy(Type(i),"P3");

    if (EQn(Type(i),"C2",2))
      for (j = 0;j < Valence(i);j++)
	if (EQn(Type(Connection(i,j)),"O2",2))
	{
	  strcpy(Type(i),"Cbl");
	  break;
	}
  }

}

void
  add_2d_hydrogens(ums_type *mol)
{

  int old_count, to_add, h_count;
  int type_valence;
  char temp_type[10];
  int result;
  int i,j;

  old_count = Atoms;
  to_add = count_missing_hydrogens(mol); 

  Atoms += to_add;
  h_count = old_count + 1;
  result = reinitialize_ums(&mol);
  zero_out_ums(mol,old_count + 1);

  for (i = 1; i <= old_count; i++)
  {
    to_add = 0;

    result = xlate_std_type("HAD",Type(i),temp_type);
    if (result == 0)
    {
      sprintf(wstr,"Unable to assign valence to atom %d type = %s",
	      i,Type(i));
      show_warning(wstr);
      strcpy(temp_type,"0");
    }
    type_valence = atoi(temp_type);
    if ((Valence(i) < type_valence) && (Valence(i) > 0))
    {
      to_add = type_valence - Valence(i);
/*       printf("num = %d type = %s val = %d \n",i,Type(i),Valence(i)); */
    }

    
    for(j = 0;j < to_add;j++)
    {
      Connection(i,Valence(i)) = h_count;
      Valence(i)++;
      Start(Bonds) = i;
      End(Bonds) = h_count;
      Bond_order(Bonds) = 1;
      Bonds++;
      sprintf(Type(h_count),"H%c",Type(i)[0]);
      Connection(h_count,0) = i;
      Valence(h_count)++;
      h_count++;
    }
  }
  
}
