/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ClassName;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Mangler;

public class JspCompiler
extends Compiler
implements Mangler {
    String pkgName;
    String javaFileName;
    String classFileName;
    String realClassName;
    File jsp;
    String outputDir;
    boolean outDated;
    static final int JSP_TOKEN_LEN = "_jsp_".length();
    public static String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};

    public JspCompiler(JspCompilationContext ctxt) throws JasperException {
        super(ctxt);
        this.jsp = new File(ctxt.getJspFile());
        this.outputDir = ctxt.getOutputDir();
        this.outDated = false;
        this.setMangler(this);
        if (this.isOutDated()) {
            this.generateNewClassName();
        }
    }

    private void generateNewClassName() {
        File classFile = new File(this.getClassFileName());
        if (!classFile.exists()) {
            String prefix = this.getPrefix(this.jsp.getPath());
            this.realClassName = String.valueOf(prefix) + this.getBaseClassName() + "_jsp_" + "0";
            return;
        }
        String cn = this.getRealClassName();
        String baseClassName = cn.substring(0, cn.lastIndexOf("_jsp_"));
        int jspTokenIdx = cn.lastIndexOf("_jsp_");
        String versionS = cn.substring(jspTokenIdx + JSP_TOKEN_LEN, cn.length());
        int number = Integer.valueOf(versionS);
        this.realClassName = String.valueOf(baseClassName) + "_jsp_" + ++number;
    }

    private final String getBaseClassName() {
        String className = this.jsp.getName().endsWith(".jsp") ? this.jsp.getName().substring(0, this.jsp.getName().length() - 4) : this.jsp.getName();
        StringBuffer modifiedClassName = new StringBuffer();
        int i = 0;
        while (i < className.length()) {
            if (Character.isLetterOrDigit(className.charAt(i))) {
                modifiedClassName.append(className.substring(i, i + 1));
            } else {
                modifiedClassName.append(JspCompiler.mangleChar(className.charAt(i)));
            }
            ++i;
        }
        return modifiedClassName.toString();
    }

    public final String getClassFileName() {
        if (this.classFileName != null) {
            return this.classFileName;
        }
        String prefix = this.getPrefix(this.jsp.getPath());
        this.classFileName = String.valueOf(prefix) + this.getBaseClassName() + ".class";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.classFileName = String.valueOf(this.outputDir) + File.separatorChar + this.classFileName;
        }
        return this.classFileName;
    }

    public final String getClassName() {
        String cn = this.getRealClassName();
        int lastDot = cn.lastIndexOf(46);
        String className = null;
        className = lastDot != -1 ? cn.substring(lastDot + 1, cn.length()) : cn;
        return className;
    }

    public final String getJavaFileName() {
        if (this.javaFileName != null) {
            return this.javaFileName;
        }
        this.javaFileName = String.valueOf(this.getClassName()) + ".java";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.javaFileName = String.valueOf(this.outputDir) + File.separatorChar + this.javaFileName;
        }
        return this.javaFileName;
    }

    public final String getPackageName() {
        if (this.pkgName != null) {
            return this.pkgName;
        }
        String pathName = this.jsp.getPath();
        StringBuffer modifiedpkgName = new StringBuffer();
        int indexOfSepChar = pathName.lastIndexOf(File.separatorChar);
        if (indexOfSepChar == -1 || indexOfSepChar == 0) {
            this.pkgName = null;
        } else {
            int i = 0;
            while (i < keywords.length) {
                char fs = File.separatorChar;
                int index1 = pathName.indexOf(String.valueOf(fs) + keywords[i]);
                int index2 = pathName.indexOf(keywords[i]);
                if (index1 != -1 || index2 != -1) {
                    int index = index2 == -1 ? index1 : index2;
                    while (index != -1) {
                        String tmpathName = String.valueOf(pathName.substring(0, index + 1)) + '%';
                        pathName = String.valueOf(tmpathName) + pathName.substring(index + 2);
                        index = pathName.indexOf(String.valueOf(fs) + keywords[i]);
                    }
                }
                ++i;
            }
            pathName = pathName.replace('.', '_');
            this.pkgName = pathName.substring(0, pathName.lastIndexOf(File.separatorChar)).replace(File.separatorChar, '.');
            int i2 = 0;
            while (i2 < this.pkgName.length()) {
                if (Character.isLetter(this.pkgName.charAt(i2)) || this.pkgName.charAt(i2) == '.') {
                    modifiedpkgName.append(this.pkgName.substring(i2, i2 + 1));
                } else {
                    modifiedpkgName.append(JspCompiler.mangleChar(this.pkgName.charAt(i2)));
                }
                ++i2;
            }
            if (modifiedpkgName.charAt(0) == '.') {
                String modifiedpkgNameString = modifiedpkgName.toString();
                this.pkgName = modifiedpkgNameString.substring(1, modifiedpkgName.length());
            } else {
                this.pkgName = modifiedpkgName.toString();
            }
        }
        return this.pkgName;
    }

    private final String getPrefix(String pathName) {
        if (pathName != null) {
            StringBuffer modifiedName = new StringBuffer();
            int i = 0;
            while (i < pathName.length()) {
                if (Character.isLetter(pathName.charAt(i))) {
                    modifiedName.append(pathName.substring(i, i + 1));
                } else {
                    modifiedName.append(JspCompiler.mangleChar(pathName.charAt(i)));
                }
                ++i;
            }
            return modifiedName.toString();
        }
        return "";
    }

    public final String getRealClassName() {
        if (this.realClassName != null) {
            return this.realClassName;
        }
        try {
            this.realClassName = ClassName.getClassName(this.getClassFileName());
        }
        catch (JasperException ex) {
            ((Throwable)((Object)ex)).printStackTrace();
            return null;
        }
        return this.realClassName;
    }

    public boolean isOutDated() {
        File jspReal = null;
        String realPath = this.ctxt.getRealPath(this.jsp.getPath());
        if (realPath == null) {
            return true;
        }
        jspReal = new File(realPath);
        File classFile = new File(this.getClassFileName());
        this.outDated = classFile.exists() ? classFile.lastModified() < jspReal.lastModified() : true;
        return this.outDated;
    }

    private static final String mangleChar(char ch) {
        if (ch == File.separatorChar) {
            ch = (char)47;
        }
        String s = Integer.toHexString(ch);
        int nzeros = 5 - s.length();
        char[] result = new char[6];
        result[0] = 95;
        int i = 1;
        while (i <= nzeros) {
            result[i] = 48;
            ++i;
        }
        int i2 = nzeros + 1;
        int j = 0;
        while (i2 < 6) {
            result[i2] = s.charAt(j);
            ++i2;
            ++j;
        }
        return new String(result);
    }
}

