/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.context;

import org.apache.tomcat.context.ExceptionHandler;
import org.apache.tomcat.context.NotFoundHandler;
import org.apache.tomcat.context.RedirectHandler;
import org.apache.tomcat.context.StatusHandler;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.TomcatException;

public class DefaultCMSetter
extends BaseInterceptor {
    public void contextInit(Context ctx) throws TomcatException {
        this.setEngineHeader(ctx);
        ctx.addServlet(new ExceptionHandler());
        ctx.addServlet(new StatusHandler());
        if (ctx.getErrorPage("302") == null) {
            ctx.addServlet(new RedirectHandler());
            ctx.addErrorPage("302", "tomcat.redirectHandler");
        }
        if (ctx.getErrorPage("404") == null) {
            ctx.addServlet(new NotFoundHandler());
            ctx.addErrorPage("404", "tomcat.notFoundHandler");
        }
    }

    private void setEngineHeader(Context ctx) {
        String engineHeader = ctx.getEngineHeader();
        if (engineHeader == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("Tomcat Web Server").append("/");
            sb.append("3.2.1");
            sb.append(" (").append("JSP").append(" ");
            sb.append("1.1");
            sb.append("; ").append("Servlet").append(" ");
            sb.append(2).append(".");
            sb.append(2);
            sb.append("; Java ");
            sb.append(System.getProperty("java.version")).append("; ");
            sb.append(String.valueOf(System.getProperty("os.name")) + " ");
            sb.append(String.valueOf(System.getProperty("os.version")) + " ");
            sb.append(String.valueOf(System.getProperty("os.arch")) + "; java.vendor=");
            sb.append(System.getProperty("java.vendor")).append(")");
            engineHeader = sb.toString();
        }
        ctx.setEngineHeader(engineHeader);
    }
}

