/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import org.apache.jasper.CommandLineContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Mangler;

public class CommandLineCompiler
extends Compiler
implements Mangler {
    String javaFileName;
    String classFileName;
    String pkgName;
    String className;
    File jsp;
    String outputDir;
    public static String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};

    public CommandLineCompiler(CommandLineContext ctxt) {
        super(ctxt);
        this.jsp = new File(ctxt.getJspFile());
        this.outputDir = ctxt.getOptions().getScratchDir().getAbsolutePath();
        this.setMangler(this);
        this.computePackageName();
        ctxt.setServletPackageName(this.pkgName);
        this.className = this.getBaseClassName();
        if (ctxt.isOutputInDirs()) {
            String tmpDir;
            File f;
            String pkgName = ctxt.getServletPackageName();
            if (pkgName == null) {
                pkgName = "";
            }
            if (!(f = new File(tmpDir = String.valueOf(this.outputDir) + File.separatorChar + pkgName.replace('.', File.separatorChar))).exists()) {
                if (f.mkdirs()) {
                    this.outputDir = tmpDir;
                }
            } else {
                this.outputDir = tmpDir;
            }
        }
        this.computeClassFileName();
        this.computeJavaFileName();
    }

    void computeClassFileName() {
        String prefix = this.getPrefix(this.jsp.getPath());
        this.classFileName = String.valueOf(prefix) + this.getBaseClassName() + ".class";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.classFileName = String.valueOf(this.outputDir) + File.separatorChar + this.classFileName;
        }
    }

    public final void computeJavaFileName() {
        this.javaFileName = String.valueOf(this.ctxt.getServletClassName()) + ".java";
        if ("null.java".equals(this.javaFileName)) {
            this.javaFileName = String.valueOf(this.getBaseClassName()) + ".java";
        }
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.javaFileName = String.valueOf(this.outputDir) + File.separatorChar + this.javaFileName;
        }
    }

    void computePackageName() {
        String pathName = this.jsp.getPath();
        StringBuffer modifiedpkgName = new StringBuffer();
        int indexOfSepChar = pathName.lastIndexOf(File.separatorChar);
        if ("".equals(this.ctxt.getServletPackageName()) || indexOfSepChar == -1 || indexOfSepChar == 0) {
            this.pkgName = null;
        } else {
            int i = 0;
            while (i < keywords.length) {
                char fs = File.separatorChar;
                int index = pathName.startsWith(String.valueOf(keywords[i]) + fs) ? 0 : pathName.indexOf(String.valueOf(fs) + keywords[i] + fs);
                while (index != -1) {
                    String tmpathName = String.valueOf(pathName.substring(0, index + 1)) + '%';
                    pathName = String.valueOf(tmpathName) + pathName.substring(index + 2);
                    index = pathName.indexOf(String.valueOf(fs) + keywords[i] + fs);
                }
                ++i;
            }
            pathName = pathName.replace('.', '_');
            this.pkgName = pathName.substring(0, pathName.lastIndexOf(File.separatorChar)).replace(File.separatorChar, '.');
            if (this.ctxt.getServletPackageName() != null) {
                this.pkgName = this.ctxt.getServletPackageName();
            }
            int i2 = 0;
            while (i2 < this.pkgName.length()) {
                if (Character.isLetter(this.pkgName.charAt(i2)) || this.pkgName.charAt(i2) == '.') {
                    modifiedpkgName.append(this.pkgName.substring(i2, i2 + 1));
                } else {
                    modifiedpkgName.append(CommandLineCompiler.mangleChar(this.pkgName.charAt(i2)));
                }
                ++i2;
            }
            if (modifiedpkgName.charAt(0) == '.') {
                String modifiedpkgNameString = modifiedpkgName.toString();
                this.pkgName = modifiedpkgNameString.substring(1, modifiedpkgName.length());
            } else {
                this.pkgName = modifiedpkgName.toString();
            }
        }
    }

    private final String getBaseClassName() {
        String className = this.ctxt.getServletClassName();
        if (className == null) {
            className = this.jsp.getName().endsWith(".jsp") ? this.jsp.getName().substring(0, this.jsp.getName().length() - 4) : this.jsp.getName();
        }
        int i = 0;
        while (i < keywords.length) {
            if (className.equals(keywords[i])) {
                className = String.valueOf(className) + "%";
            }
            ++i;
        }
        StringBuffer modifiedClassName = new StringBuffer();
        int i2 = 0;
        while (i2 < className.length()) {
            if (Character.isLetterOrDigit(className.charAt(i2))) {
                modifiedClassName.append(className.substring(i2, i2 + 1));
            } else {
                modifiedClassName.append(CommandLineCompiler.mangleChar(className.charAt(i2)));
            }
            ++i2;
        }
        return modifiedClassName.toString();
    }

    public final String getClassFileName() {
        return this.classFileName;
    }

    public final String getClassName() {
        return this.className;
    }

    private final String getInitialClassName() {
        String prefix = this.getPrefix(this.jsp.getPath());
        return String.valueOf(prefix) + this.getBaseClassName() + "_jsp_" + "0";
    }

    public final String getJavaFileName() {
        return this.javaFileName;
    }

    public final String getPackageName() {
        return this.pkgName;
    }

    private final String getPrefix(String pathName) {
        if (pathName != null) {
            StringBuffer modifiedName = new StringBuffer();
            int i = 0;
            while (i < pathName.length()) {
                if (Character.isLetter(pathName.charAt(i))) {
                    modifiedName.append(pathName.substring(i, i + 1));
                } else {
                    modifiedName.append(CommandLineCompiler.mangleChar(pathName.charAt(i)));
                }
                ++i;
            }
            return modifiedName.toString();
        }
        return "";
    }

    public boolean isOutDated() {
        return true;
    }

    private static final String mangleChar(char ch) {
        if (ch == File.separatorChar) {
            ch = (char)47;
        }
        String s = Integer.toHexString(ch);
        int nzeros = 5 - s.length();
        char[] result = new char[6];
        result[0] = 95;
        int i = 1;
        while (i <= nzeros) {
            result[i] = 48;
            ++i;
        }
        int i2 = nzeros + 1;
        int j = 0;
        while (i2 < 6) {
            result[i2] = s.charAt(j);
            ++i2;
            ++j;
        }
        return new String(result);
    }
}

