/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.ant.Task;

public class LogOutputStream
extends OutputStream {
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private boolean skip = false;
    private Task task;
    private int level = 2;

    public LogOutputStream(Task task, int level) {
        this.task = task;
        this.level = level;
    }

    public void close() throws IOException {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
        super.close();
    }

    public int getMessageLevel() {
        return this.level;
    }

    protected void processBuffer() {
        this.processLine(this.buffer.toString());
        this.buffer.reset();
    }

    protected void processLine(String line) {
        this.processLine(line, this.level);
    }

    protected void processLine(String line, int level) {
        this.task.log(line, level);
    }

    public void write(int cc) throws IOException {
        byte c = (byte)cc;
        if (c == 10 || c == 13) {
            if (!this.skip) {
                this.processBuffer();
            }
        } else {
            this.buffer.write(cc);
        }
        this.skip = c == 13;
    }
}

