/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;

public class JUnitTestRunner
implements TestListener {
    public static final int SUCCESS = 0;
    public static final int FAILURES = 1;
    public static final int ERRORS = 2;
    private Vector formatters = new Vector();
    private TestResult res;
    private boolean haltOnError = false;
    private boolean haltOnFailure = false;
    private Test suite = null;
    private Exception exception;
    private int retCode = 0;
    private JUnitTest junitTest;
    private static Vector fromCmdLine = new Vector();

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean haltOnFailure) {
        this(test, haltOnError, haltOnFailure, null);
    }

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean haltOnFailure, ClassLoader loader) {
        this.junitTest = test;
        this.haltOnError = haltOnError;
        this.haltOnFailure = haltOnFailure;
        try {
            Class<?> testClass = null;
            testClass = loader == null ? Class.forName(test.getName()) : loader.loadClass(test.getName());
            try {
                Method suiteMethod = testClass.getMethod("suite", new Class[0]);
                this.suite = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            if (this.suite == null) {
                this.suite = new TestSuite(testClass);
            }
        }
        catch (Exception e) {
            this.retCode = 2;
            this.exception = e;
        }
    }

    public void addError(Test test, Throwable t) {
        if (this.haltOnError) {
            this.res.stop();
        }
    }

    public void addFailure(Test test, Throwable t) {
        if (this.haltOnFailure) {
            this.res.stop();
        }
    }

    public void addFormatter(JUnitResultFormatter f) {
        this.formatters.addElement(f);
    }

    private static void createAndStoreFormatter(String line) throws BuildException {
        FormatterElement fe = new FormatterElement();
        StringTokenizer tok = new StringTokenizer(line, ",");
        fe.setClassname(tok.nextToken());
        if (tok.hasMoreTokens()) {
            fe.setOutfile(new File(tok.nextToken()));
        }
        fromCmdLine.addElement(fe.createFormatter());
    }

    public void endTest(Test test) {
    }

    private void fireEndTestSuite() {
        int i = 0;
        while (i < this.formatters.size()) {
            ((JUnitResultFormatter)this.formatters.elementAt(i)).endTestSuite(this.junitTest);
            ++i;
        }
    }

    private void fireStartTestSuite() {
        int i = 0;
        while (i < this.formatters.size()) {
            ((JUnitResultFormatter)this.formatters.elementAt(i)).startTestSuite(this.junitTest);
            ++i;
        }
    }

    public int getRetCode() {
        return this.retCode;
    }

    public static void main(String[] args) throws IOException {
        boolean exitAtEnd = true;
        boolean haltError = false;
        boolean haltFail = false;
        if (args.length == 0) {
            System.err.println("required argument TestClassName missing");
            System.exit(2);
        }
        int i = 1;
        while (i < args.length) {
            if (args[i].startsWith("haltOnError=")) {
                haltError = Project.toBoolean(args[i].substring(12));
            } else if (args[i].startsWith("haltOnFailure=")) {
                haltFail = Project.toBoolean(args[i].substring(14));
            } else if (args[i].startsWith("formatter=")) {
                try {
                    JUnitTestRunner.createAndStoreFormatter(args[i].substring(10));
                }
                catch (BuildException be) {
                    System.err.println(be.getMessage());
                    System.exit(2);
                }
            }
            ++i;
        }
        JUnitTest t = new JUnitTest(args[0]);
        JUnitTestRunner runner = new JUnitTestRunner(t, haltError, haltFail);
        JUnitTestRunner.transferFormatters(runner);
        runner.run();
        System.exit(runner.getRetCode());
    }

    public void run() {
        this.res = new TestResult();
        this.res.addListener((TestListener)this);
        int i = 0;
        while (i < this.formatters.size()) {
            this.res.addListener((TestListener)this.formatters.elementAt(i));
            ++i;
        }
        long start = System.currentTimeMillis();
        this.fireStartTestSuite();
        if (this.exception != null) {
            int i2 = 0;
            while (i2 < this.formatters.size()) {
                ((TestListener)this.formatters.elementAt(i2)).addError(null, (Throwable)this.exception);
                ++i2;
            }
            this.junitTest.setCounts(1L, 0L, 1L);
            this.junitTest.setRunTime(0L);
        } else {
            this.suite.run(this.res);
            this.junitTest.setCounts(this.res.runCount(), this.res.failureCount(), this.res.errorCount());
            this.junitTest.setRunTime(System.currentTimeMillis() - start);
        }
        this.fireEndTestSuite();
        if (this.retCode != 0 || this.res.errorCount() != 0) {
            this.retCode = 2;
        } else if (this.res.failureCount() != 0) {
            this.retCode = 1;
        }
    }

    public void startTest(Test t) {
    }

    private static void transferFormatters(JUnitTestRunner runner) {
        int i = 0;
        while (i < fromCmdLine.size()) {
            runner.addFormatter((JUnitResultFormatter)fromCmdLine.elementAt(i));
            ++i;
        }
    }
}

