/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.jdom.IllegalTargetException;
import org.jdom.Verifier;

public class ProcessingInstruction
implements Serializable,
Cloneable {
    protected String target;
    protected String rawData;
    protected Map mapData;

    protected ProcessingInstruction() {
    }

    public ProcessingInstruction(String string, Map map) {
        String string2 = Verifier.checkProcessingInstructionTarget(string);
        if (string2 != null) {
            throw new IllegalTargetException(string, string2);
        }
        this.target = string;
        this.setData(map);
    }

    public ProcessingInstruction(String string, String string2) {
        String string3 = Verifier.checkProcessingInstructionTarget(string);
        if (string3 != null) {
            throw new IllegalTargetException(string, string3);
        }
        this.target = string;
        this.setData(string2);
    }

    public String getTarget() {
        return this.target;
    }

    public String getData() {
        return this.rawData;
    }

    public ProcessingInstruction setData(String string) {
        this.rawData = string;
        this.mapData = this.parseData(string);
        return this;
    }

    public ProcessingInstruction setData(Map map) {
        this.rawData = this.toString(map);
        this.mapData = map;
        return this;
    }

    public String getValue(String string) {
        if (this.mapData.containsKey((Object)string)) {
            return (String)this.mapData.get((Object)string);
        }
        return "";
    }

    public ProcessingInstruction setValue(String string, String string2) {
        this.mapData.put((Object)string, (Object)string2);
        this.rawData = this.toString(this.mapData);
        return this;
    }

    public boolean removeValue(String string) {
        if (this.mapData.remove((Object)string) != null) {
            this.rawData = this.toString(this.mapData);
            return true;
        }
        return false;
    }

    private String toString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get((Object)string);
            stringBuffer.append(string).append("=\"").append(string2).append("\" ");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    private Map parseData(String string) {
        HashMap hashMap = new HashMap();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "='\"");
            if (stringTokenizer2.countTokens() < 2) continue;
            String string2 = stringTokenizer2.nextToken();
            String string3 = stringTokenizer2.nextToken();
            hashMap.put((Object)string2, (Object)string3);
        }
        return hashMap;
    }

    public final String toString() {
        return "[Processing Instruction: " + this.getSerializedForm() + "]";
    }

    public final String getSerializedForm() {
        return "<?" + this.target + " " + this.rawData + "?>";
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final Object clone() {
        ProcessingInstruction processingInstruction = new ProcessingInstruction(this.target, this.rawData);
        return processingInstruction;
    }
}

