/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import com.sun.java.util.collections.LinkedList;
import java.io.IOException;
import java.util.Stack;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Entity;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

class SAXHandler
extends DefaultHandler
implements LexicalHandler {
    private Document document;
    private Stack stack;
    private boolean atRoot;
    private boolean inDTD;
    private boolean inCDATA;
    private boolean inEntity;
    private LinkedList namespaces;

    public SAXHandler(Document document) throws IOException {
        this.document = document;
        this.atRoot = true;
        this.stack = new Stack();
        this.namespaces = new LinkedList();
        this.namespaces.add((Object)Namespace.XML_NAMESPACE);
        this.inEntity = false;
        this.inDTD = false;
        this.inCDATA = false;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.atRoot) {
            this.document.addContent(new ProcessingInstruction(string, string2));
            return;
        }
        ((Element)this.stack.peek()).addContent(new ProcessingInstruction(string, string2));
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        Namespace namespace = Namespace.getNamespace(string, string2);
        this.namespaces.add((Object)namespace);
    }

    public void endPrefixMapping(String string, String string2) throws SAXException {
        Namespace namespace = Namespace.getNamespace(string, string2);
        this.namespaces.remove((Object)namespace);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n;
        Element element = null;
        if (string != null && !string.equals("")) {
            String string4 = "";
            if (string2 != string3) {
                n = string3.indexOf(":");
                string4 = string3.substring(0, n);
            }
            element = new Element(string2, Namespace.getNamespace(string4, string));
        } else {
            element = new Element(string2);
        }
        int n2 = 0;
        n = attributes.getLength();
        while (n2 < n) {
            String string5;
            Attribute attribute = null;
            String string6 = attributes.getLocalName(n2);
            if (string6 != (string5 = attributes.getQName(n2))) {
                String string7 = string5.substring(0, string5.indexOf(":"));
                attribute = new Attribute(string6, attributes.getValue(n2), this.getNamespace(string7));
            } else {
                attribute = new Attribute(string6, attributes.getValue(n2));
            }
            element.addAttribute(attribute);
            ++n2;
        }
        if (this.atRoot) {
            this.document.setRootElement(element);
            this.stack.push(element);
            this.atRoot = false;
            return;
        }
        ((Element)this.stack.peek()).addContent(element);
        this.stack.push(element);
    }

    private Namespace getNamespace(String string) {
        int n = this.namespaces.size();
        while (n > 0) {
            Namespace namespace = (Namespace)this.namespaces.get(n - 1);
            if (string.equals(namespace.getPrefix())) {
                return namespace;
            }
            --n;
        }
        return Namespace.NO_NAMESPACE;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.inCDATA) {
            ((Element)this.stack.peek()).addContent(new CDATA(string));
            return;
        }
        if (!this.inDTD) {
            if (this.inEntity) {
                ((Entity)this.stack.peek()).setContent(string);
                return;
            }
            Element element = (Element)this.stack.peek();
            element.addContent(string);
        }
    }

    public void endElement(String string, String string2, String string3) {
        this.stack.pop();
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.document.setDocType(new DocType(string, string2, string3));
        this.inDTD = true;
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void startEntity(String string) throws SAXException {
        if (!(this.inDTD || string.equals("amp") || string.equals("lt") || string.equals("gt") || string.equals("apos") || string.equals("quot"))) {
            Entity entity = new Entity(string);
            ((Element)this.stack.peek()).addContent(entity);
            this.stack.push(entity);
            this.inEntity = true;
        }
    }

    public void endEntity(String string) throws SAXException {
        if (this.inEntity) {
            this.stack.pop();
            this.inEntity = false;
        }
    }

    public void startCDATA() throws SAXException {
        this.inCDATA = true;
    }

    public void endCDATA() throws SAXException {
        this.inCDATA = false;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (!this.inDTD && !string.equals("")) {
            if (this.stack.empty()) {
                this.document.addContent(new Comment(string));
                return;
            }
            ((Element)this.stack.peek()).addContent(new Comment(string));
        }
    }
}

