/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.xpath.a;

import java.util.StringTokenizer;
import org.jdom.contrib.xpath.XPathParseException;
import org.jdom.contrib.xpath.a.XPathParser;
import org.jdom.contrib.xpath.a.XPathPredicateHandler;
import org.jdom.contrib.xpath.a.XPathPredicateParser;

public class PoCPredicateParser
implements XPathPredicateParser {
    private static final String DELIM = " ,([/'\"*+=$";
    private XPathPredicateHandler handler;
    private XPathParser xpathParser;

    public void setXPathPredicateHandler(XPathPredicateHandler xPathPredicateHandler) {
        this.handler = xPathPredicateHandler;
    }

    public XPathPredicateHandler getXPathPredicateHandler() {
        return this.handler;
    }

    public void setXPathParser(XPathParser xPathParser) {
        this.xpathParser = xPathParser;
    }

    public XPathParser getXPathParser() {
        return this.xpathParser;
    }

    public void parsePredicate(String string) throws XPathParseException {
        this.handler.startPredicate();
        this.parse(string);
        this.handler.endPredicate();
    }

    private void parse(String string) throws XPathParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            char c = '\u0000';
            if (!stringTokenizer.hasMoreTokens()) {
                this.parseThing(string2);
                return;
            }
            c = stringTokenizer.nextToken().charAt(0);
            switch (c) {
                case ' ': {
                    if ("or".equals(string2)) {
                        this.handler.opcode(1);
                        break;
                    }
                    if ("and".equals(string2)) {
                        this.handler.opcode(2);
                        break;
                    }
                    this.parseThing(string2);
                    break;
                }
                case '(': {
                    this.handler.function(string2, new String[]{stringTokenizer.nextToken(")")});
                    break;
                }
                case '\'': {
                    this.handler.literal(stringTokenizer.nextToken("'"));
                    break;
                }
                case '\"': {
                    this.handler.literal(stringTokenizer.nextToken("\""));
                    break;
                }
                case '$': {
                    this.handler.variable(stringTokenizer.nextToken());
                    break;
                }
                case '=': {
                    System.out.print("{PocParse unknown: " + string2 + " " + c + "}");
                    break;
                }
                case '+': {
                    System.out.print("{PocParse unknown: " + string2 + " " + c + "}");
                    break;
                }
                case '*': {
                    System.out.print("{PocParse unknown: " + string2 + " " + c + "}");
                    break;
                }
                case ',': {
                    System.out.print("{PocParse unknown: " + string2 + " " + c + "}");
                    break;
                }
                case '[': {
                    System.out.print("{PocParse unknown: " + string2 + " " + c + "}");
                    break;
                }
                case '/': {
                    System.out.print("{PocParse unknown: " + string2 + " " + c + "}");
                    break;
                }
                default: {
                    throw new XPathParseException("Internal error: " + c + " not expected parsing predicate.");
                }
            }
        }
    }

    private void parseThing(String string) throws XPathParseException {
        if (string.charAt(0) >= '0' && string.charAt(0) <= '9') {
            this.handler.number(string);
            return;
        }
        System.out.print("{PocParse path: " + string + "}");
    }
}

