/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.xpath;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.contrib.xpath.XPath;
import org.jdom.contrib.xpath.jdom.JdomNodeSet;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class TestDriver {
    public static void main(String[] args) throws Exception {
        System.out.println("XPath Test Driver");
        if (args.length != 2) {
            System.err.println("Usage: java ...TestDriver <input file> <xpath_expr>");
            System.exit(1);
        }
        SAXBuilder builder = new SAXBuilder();
        File inFile = new File(args[0]);
        String xpathExpr = args[1];
        Document doc = builder.build(inFile);
        try {
            XMLOutputter outputter = new XMLOutputter("  ", true);
            outputter.output(doc, (OutputStream)System.out);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        System.out.println();
        System.out.println();
        XPath xpath = new XPath(xpathExpr);
        JdomNodeSet nodeset = new JdomNodeSet(doc.getRootElement());
        nodeset.apply(xpath);
        Element resultRoot = new Element("xpath-results");
        Document resultDoc = new Document(resultRoot);
        Iterator iter = nodeset.iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (each instanceof Element) {
                resultRoot.addContent((Element)((Element)each).clone());
                System.out.println(String.valueOf(String.valueOf(each)) + ": " + ((Element)each).getTextTrim());
                continue;
            }
            System.out.println(each);
        }
    }
}

