/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.xpath.a;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.ProcessingInstruction;
import org.jdom.contrib.xpath.XPathElement;
import org.jdom.contrib.xpath.XPathParseException;
import org.jdom.contrib.xpath.a.DefaultHandler;
import org.jdom.contrib.xpath.a.PoCParser;
import org.jdom.contrib.xpath.a.PrintHandler;
import org.jdom.contrib.xpath.a.XPathHandler;
import org.jdom.contrib.xpath.a.XPathParser;
import org.jdom.contrib.xpath.a.XPathPredicateHandler;
import org.jdom.contrib.xpath.impl.Axis;
import org.jdom.contrib.xpath.impl.Nodetype;

public class JDOMLocator
implements XPathHandler {
    public static boolean DEBUG = XPathElement.DEBUG;
    private List matchList;
    private List pathList;
    private List stepList;
    private Element originalContext;
    private XPathParser parser;
    private boolean absolute = false;
    private XPathElement reusableXPathElement;

    public void absolute() throws XPathParseException {
        this.absolute = true;
        JDOMLocator.print("{absolute}");
        this.pathList.clear();
        this.pathList.add(this.elemext(this.originalContext).getRootElement());
    }

    private XPathElement elemext(Element element) {
        if (this.reusableXPathElement == null) {
            this.reusableXPathElement = new XPathElement(element);
        } else {
            this.reusableXPathElement.extend(element);
        }
        return this.reusableXPathElement;
    }

    public void endParsingXPath() throws XPathParseException {
        JDOMLocator.println("{/parse}");
    }

    public void endPath() throws XPathParseException {
        JDOMLocator.print("{/path}");
        this.matchList.addAll(this.pathList);
        this.pathList.clear();
    }

    public void endStep() throws XPathParseException {
        this.pathList = this.stepList;
        this.stepList = new ArrayList();
        JDOMLocator.print("{/step}");
    }

    public void endXPathPredicate(XPathPredicateHandler handler) {
        JDOMLocatorPredicateHandler predicate = (JDOMLocatorPredicateHandler)handler;
        if (predicate.getPosition() != null) {
            ArrayList list = new ArrayList();
            if (predicate.getPosition() > 0 && this.stepList.size() >= predicate.getPosition()) {
                list.add(this.stepList.get(predicate.getPosition() - 1));
            }
            this.stepList = list;
        }
        JDOMLocator.print("{/pred}");
    }

    public List match(String xpath) throws XPathParseException {
        DEBUG = XPathElement.DEBUG;
        JDOMLocator.println();
        if (this.parser == null) {
            this.parser = new PoCParser();
        }
        this.parser.setXPathHandler(this);
        this.parser.parse(xpath);
        return this.matchList;
    }

    public void nametest(String axis, String prefix, String localName) throws XPathParseException {
        this.nodetest(axis, null, prefix, localName);
    }

    private void nodetest(String axisString, String nodetypeString, String prefix, String localName) throws XPathParseException {
        Axis axis = new Axis(axisString);
        Nodetype nodetype = new Nodetype(nodetypeString);
        JDOMLocator.print("{nodetest=" + axis.getString() + " " + nodetype.getString() + " " + (prefix == null ? "" : prefix) + " " + (localName == null ? "" : localName) + "}");
        if ("*".equals(localName)) {
            localName = null;
        }
        if (axis.getCode() == 0) {
            throw new XPathParseException("Unrecognized axis: " + axis);
        }
        if (nodetype != null && nodetype.getCode() == 0) {
            throw new XPathParseException("Unrecognized nodetype: " + nodetype);
        }
        this.nodetest(axis, nodetype, prefix, localName);
    }

    private void nodetest(Axis axis, Nodetype nodetype, String prefix, String localName) throws XPathParseException {
        Iterator iter = this.pathList.iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            switch (axis.getCode()) {
                case 2: {
                    this.nodetestAncestor(each, nodetype, prefix, localName, false, true);
                    break;
                }
                case 3: {
                    this.nodetestAncestor(each, nodetype, prefix, localName, true, true);
                    break;
                }
                case 4: {
                    this.nodetestAttribute(each, nodetype, prefix, localName);
                    break;
                }
                case 5: {
                    this.nodetestChild(each, nodetype, prefix, localName);
                    break;
                }
                case 6: {
                    this.nodetestDescendant(each, nodetype, prefix, localName, false);
                    break;
                }
                case 7: {
                    this.nodetestDescendant(each, nodetype, prefix, localName, true);
                    break;
                }
                case 8: {
                    throw new NotImplementedException("Support for axis following is not implemented. ");
                }
                case 9: {
                    throw new NotImplementedException("Support for axis following-sibling is not implemented. ");
                }
                case 10: {
                    this.nodetestNamespace(each, nodetype, prefix, localName);
                    break;
                }
                case 11: {
                    this.nodetestAncestor(each, nodetype, prefix, localName, true, false);
                    break;
                }
                case 12: {
                    throw new NotImplementedException("Support for axis preceding is not implemented. ");
                }
                case 13: {
                    throw new NotImplementedException("Support for axis preceding-sibling is not implemented. ");
                }
                case 14: {
                    this.nodetestSelf(each, nodetype, prefix, localName);
                    break;
                }
            }
        }
    }

    private void nodetestAncestor(Object context, Nodetype nodetype, String prefix, String localName, boolean self, boolean recursive) throws XPathParseException {
        if ((nodetype.getCode() == 5 || nodetype.getCode() == 1) && context instanceof Element) {
            Element element = (Element)context;
            if (self) {
                this.stepList.add(element);
            }
            if (recursive) {
                this.stepList.addAll(this.elemext(element).getAncestors());
            } else {
                this.stepList.add(element.getParent());
            }
        }
    }

    private void nodetestAttribute(Object context, Nodetype nodetype, String prefix, String localName) throws XPathParseException {
        if (!(context instanceof Element)) {
            return;
        }
        Element element = (Element)context;
        switch (nodetype.getCode()) {
            case 5: {
                if (localName == null) {
                    JDOMLocator.print("*");
                    this.stepList.addAll(element.getAttributes());
                    break;
                }
                JDOMLocator.print("#");
                Attribute attr = this.elemext(element).getAttribute(prefix, localName);
                if (attr == null) break;
                this.stepList.add(attr);
                break;
            }
            default: {
                throw new XPathParseException("Cannot have axis=ATTRIBUTE for any other than nodetype=ELEMENT.");
            }
        }
    }

    private void nodetestChild(Object context, Nodetype nodetype, String prefix, String localName) throws XPathParseException {
        if (!(context instanceof Element)) {
            return;
        }
        Element element = (Element)context;
        switch (nodetype.getCode()) {
            case 1: {
                if (localName == null) {
                    this.stepList.addAll(element.getMixedContent());
                    break;
                }
                throw new XPathParseException("LocalName for nodes is meaningless.  (localName=" + localName + ")");
            }
            case 5: {
                this.stepList.addAll(this.elemext(element).getChildren(prefix, localName));
                break;
            }
            case 2: {
                if (localName == null) {
                    this.stepList.addAll(this.elemext(element).getComments());
                    break;
                }
                throw new XPathParseException("LocalName for comments is meaningless.  (localName=" + localName + ")");
            }
            case 3: {
                if (localName == null) {
                    this.stepList.addAll(this.elemext(element).getTextChildren());
                    break;
                }
                throw new XPathParseException("LocalName for text is meaningless.  (localName=" + localName + ")");
            }
            case 4: {
                if (localName == null) {
                    this.stepList.addAll(this.elemext(element).getProcessingInstructions());
                    break;
                }
                this.stepList.addAll(this.elemext(element).getProcessingInstructions(localName));
                break;
            }
        }
    }

    private void nodetestDescendant(Object context, Nodetype nodetype, String prefix, String localName, boolean self) throws XPathParseException {
        switch (nodetype.getCode()) {
            case 1: 
            case 5: {
                if (!(context instanceof Element)) break;
                this.stepList.addAll(this.elemext((Element)context).getDescendants(prefix, localName, self));
                break;
            }
        }
    }

    private void nodetestNamespace(Object context, Nodetype nodetype, String prefix, String localName) throws XPathParseException {
        if ((nodetype.getCode() == 5 || nodetype.getCode() == 1) && context instanceof Element) {
            Element element = (Element)context;
            this.stepList.addAll(this.elemext(element).getNamespaces());
        }
    }

    private void nodetestSelf(Object context, Nodetype nodetype, String prefix, String localName) throws XPathParseException {
        switch (nodetype.getCode()) {
            case 1: {
                this.stepList.add(context);
                break;
            }
            case 5: {
                if (!(context instanceof Element)) break;
                this.stepList.add(context);
                break;
            }
            case 2: {
                if (!(context instanceof Comment)) break;
                this.stepList.add(context);
                break;
            }
            case 3: {
                if (!(context instanceof String)) break;
                this.stepList.add(context);
                break;
            }
            case 4: {
                if (!(context instanceof ProcessingInstruction)) break;
                if (localName == null) {
                    this.stepList.add(context);
                    break;
                }
                ProcessingInstruction pi = (ProcessingInstruction)context;
                if (!localName.equals(pi.getTarget())) break;
                this.stepList.add(context);
                break;
            }
        }
    }

    public void nodetype(String axis, String nodetype, String literal) throws XPathParseException {
        this.nodetest(axis, nodetype, null, literal);
    }

    protected static void print(Object message) {
        if (DEBUG) {
            System.out.print(message);
        }
    }

    protected static void println() {
        if (DEBUG) {
            System.out.println();
        }
    }

    protected static void println(Object message) {
        if (DEBUG) {
            System.out.println(message);
        }
    }

    public void setContextElement(Element context) {
        this.originalContext = context;
    }

    public void setMatchList(List matchList) {
        this.matchList = matchList;
    }

    public void setParser(XPathParser parser) {
        this.parser = parser;
    }

    public void startParsingXPath() throws XPathParseException {
        if (this.originalContext == null) {
            throw new XPathParseException("JDOMLocator requires a context element.");
        }
        if (this.matchList == null) {
            this.matchList = new ArrayList();
        }
        this.pathList = new ArrayList();
        this.stepList = new ArrayList();
    }

    public void startPath() throws XPathParseException {
        JDOMLocator.print("{path}");
        this.pathList.add(this.originalContext);
    }

    public void startStep() throws XPathParseException {
        JDOMLocator.print("{step}");
    }

    public XPathPredicateHandler startXPathPredicate() {
        JDOMLocator.print("{pred}");
        return new JDOMLocatorPredicateHandler();
    }

    class JDOMLocatorPredicateHandler
    extends DefaultHandler
    implements XPathPredicateHandler {
        private Integer position = null;

        JDOMLocatorPredicateHandler() {
            PrintHandler.DEBUG = XPathElement.DEBUG;
        }

        public void endPredicate() throws XPathParseException {
        }

        Integer getPosition() {
            return this.position;
        }

        public void number(String number) throws XPathParseException {
            PrintHandler.print("{number=" + number + "}");
            if (number.indexOf(46) != -1) {
                throw new NotImplementedException("Support for position numbers only are implemented. " + number);
            }
            this.position = new Integer(number);
        }

        public void startPredicate() throws XPathParseException {
        }
    }

    class NotImplementedException
    extends XPathParseException {
        public NotImplementedException(String message) {
            super(message);
        }

        public NotImplementedException(String message, Throwable rootCause) {
            super(message, rootCause);
        }
    }
}

