/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.xpath.a;

import java.util.StringTokenizer;
import org.jdom.contrib.xpath.XPathParseException;
import org.jdom.contrib.xpath.a.XPathParser;
import org.jdom.contrib.xpath.a.XPathPredicateHandler;
import org.jdom.contrib.xpath.a.XPathPredicateParser;

public class PoCPredicateParser
implements XPathPredicateParser {
    private static final String DELIM = " ,([/'\"*+=$";
    private XPathPredicateHandler handler;
    private XPathParser xpathParser;

    public XPathParser getXPathParser() {
        return this.xpathParser;
    }

    public XPathPredicateHandler getXPathPredicateHandler() {
        return this.handler;
    }

    private void parse(String predicate) throws XPathParseException {
        StringTokenizer st = new StringTokenizer(predicate, DELIM, true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            char delim = '\u0000';
            if (!st.hasMoreTokens()) {
                this.parseThing(token);
                return;
            }
            delim = st.nextToken().charAt(0);
            switch (delim) {
                case ' ': {
                    if ("or".equals(token)) {
                        this.handler.opcode(1);
                        break;
                    }
                    if ("and".equals(token)) {
                        this.handler.opcode(2);
                        break;
                    }
                    this.parseThing(token);
                    break;
                }
                case '(': {
                    this.handler.function(token, new String[]{st.nextToken(")")});
                    break;
                }
                case '\'': {
                    this.handler.literal(st.nextToken("'"));
                    break;
                }
                case '\"': {
                    this.handler.literal(st.nextToken("\""));
                    break;
                }
                case '$': {
                    this.handler.variable(st.nextToken());
                    break;
                }
                case '=': {
                    System.out.print("{PocParse unknown: " + token + " " + delim + "}");
                    break;
                }
                case '+': {
                    System.out.print("{PocParse unknown: " + token + " " + delim + "}");
                    break;
                }
                case '*': {
                    System.out.print("{PocParse unknown: " + token + " " + delim + "}");
                    break;
                }
                case ',': {
                    System.out.print("{PocParse unknown: " + token + " " + delim + "}");
                    break;
                }
                case '[': {
                    System.out.print("{PocParse unknown: " + token + " " + delim + "}");
                    break;
                }
                case '/': {
                    System.out.print("{PocParse unknown: " + token + " " + delim + "}");
                    break;
                }
                default: {
                    throw new XPathParseException("Internal error: " + delim + " not expected parsing predicate.");
                }
            }
        }
    }

    public void parsePredicate(String predicate) throws XPathParseException {
        this.handler.startPredicate();
        this.parse(predicate);
        this.handler.endPredicate();
    }

    private void parseThing(String thing) throws XPathParseException {
        if (thing.charAt(0) >= '0' && thing.charAt(0) <= '9') {
            this.handler.number(thing);
        } else {
            System.out.print("{PocParse path: " + thing + "}");
        }
    }

    public void setXPathParser(XPathParser xpathParser) {
        this.xpathParser = xpathParser;
    }

    public void setXPathPredicateHandler(XPathPredicateHandler handler) {
        this.handler = handler;
    }
}

