/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.xpath.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.contrib.xpath.NodeSet;
import org.jdom.contrib.xpath.XPathParseException;
import org.jdom.contrib.xpath.impl.Axis;
import org.jdom.contrib.xpath.impl.Nodetype;
import org.jdom.contrib.xpath.impl.Predicate;
import org.jdom.contrib.xpath.impl.XPathExprImpl;

public class Step
extends XPathExprImpl {
    private boolean isAbsolute = false;
    private Axis axis = null;
    private Nodetype nodetype = null;
    private String prefix = null;
    private String localName = null;
    private List predicates = new ArrayList();

    public Step(String axis, String nodetype, String prefix, String localName) {
        this.axis = new Axis(axis);
        this.nodetype = new Nodetype(nodetype);
        this.prefix = prefix;
        this.localName = localName;
    }

    public void addPredicate(Predicate pred) {
        this.predicates.add(pred);
    }

    public void apply(NodeSet nodeset) throws XPathParseException {
        System.out.println("before nodetest: " + nodeset);
        nodeset.applyNodetest(this);
        System.out.println("after nodetest: " + nodeset);
        Iterator iter = this.predicates.iterator();
        while (iter.hasNext()) {
            Predicate each = (Predicate)iter.next();
            nodeset.applyPredicate(each);
            System.out.println("after " + each + ": " + nodeset);
        }
    }

    public Axis getAxis() {
        return this.axis;
    }

    public String getLocalName() {
        return this.localName;
    }

    public Nodetype getNodetype() {
        return this.nodetype;
    }

    public List getPredicates() {
        return this.predicates;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public void setAbsolute(boolean isAbsolute) {
        System.err.println("Step.setAbsolute(" + isAbsolute + ")");
        this.isAbsolute = isAbsolute;
    }

    public String toString() {
        return "[Step: " + (this.isAbsolute ? "/" : "") + this.axis + this.nodetype + this.prefix + ":" + this.localName + "]";
    }
}

