/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Type;

class ArrayType
implements Type {
    private final int dimension;
    private final Type type;

    ArrayType(Type type, int n) {
        this.type = type;
        this.dimension = n;
    }

    public ClassDoc asClassDoc() {
        return this.type.asClassDoc();
    }

    public String dimension() {
        switch (this.dimension) {
            case 0: {
                return "";
            }
            case 1: {
                return "[]";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.dimension) {
            stringBuffer.append("[]");
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)object;
            return this.dimension == arrayType.dimension && this.type.equals(arrayType.type);
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode() + this.dimension;
    }

    public String qualifiedTypeName() {
        return this.type.qualifiedTypeName();
    }

    public String toString() {
        return String.valueOf(this.type.toString()) + this.dimension();
    }

    public String typeName() {
        return this.type.typeName();
    }
}

