/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.agent;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.tools.agent.Agent;
import sun.tools.agent.AgentConstants;
import sun.tools.agent.Breakpoint;
import sun.tools.agent.Event;
import sun.tools.agent.MainThread;

class Handler
extends Thread
implements AgentConstants {
    static Event the_event;
    private Agent agent;
    private Hashtable catchHash;
    static final boolean debug = false;

    Handler(Agent agent) {
        super("Breakpoint handler");
        the_event = new Event();
        Handler.the_event.waiting_for_event = false;
        this.catchHash = new Hashtable();
        this.agent = agent;
    }

    synchronized void catchExceptionClass(Class clazz) {
        if (this.catchHash.get(clazz) == null) {
            this.catchHash.put(clazz, clazz);
        }
    }

    Class[] getCatchList() {
        Class[] classArray = new Class[this.catchHash.size()];
        Enumeration enumeration = this.catchHash.elements();
        int n = 0;
        while (n < classArray.length) {
            classArray[n] = (Class)enumeration.nextElement();
            ++n;
        }
        return classArray;
    }

    private void handleBreakpoint() throws IOException {
        boolean bl;
        Breakpoint breakpoint = Breakpoint.get(the_event.getMethod(), Handler.the_event.bci);
        if (breakpoint == null) {
            Agent.message("Ignoring breakpoint notification: ");
            Agent.message("  received after breakpoint cancelled.");
            Agent.message("  Breakpoint list: ");
            Enumeration enumeration = Breakpoint.allBreakpoints();
            while (enumeration.hasMoreElements()) {
                Agent.message("    " + enumeration.nextElement());
            }
            return;
        }
        if (breakpoint.thread != null && breakpoint.thread != Handler.the_event.thread) {
            return;
        }
        this.agent.setSingleStep(Handler.the_event.thread, false);
        this.agent.suspendAllThreads();
        if (breakpoint.type == 2) {
            Breakpoint.deleteBreakpoint(breakpoint.getMethod(), breakpoint.bci);
        }
        if (!(bl = this.agent.stepHandler.notifyBreak(the_event))) {
            this.agent.reportBreakpoint(the_event);
        }
    }

    private void handleException() throws IOException {
        if (Handler.the_event.exception instanceof ThreadDeath) {
            if (Handler.the_event.exception == MainThread.rethrownDeath) {
                Agent.message("rethrown ThreadDeath - ignoring");
            } else {
                Agent.message("Received ThreadDeath event: " + the_event);
                this.agent.setSingleStep(Handler.the_event.thread, false);
                this.agent.stepHandler.notifyException(the_event, false);
            }
        } else {
            Class<?> clazz = Handler.the_event.exception.getClass();
            boolean bl = false;
            while (!bl && clazz != null) {
                bl = this.catchHash.containsKey(clazz);
                clazz = clazz.getSuperclass();
            }
            boolean bl2 = Handler.the_event.catch_clazz == this.agent.mainCallerClass || Handler.the_event.catch_clazz == null;
            boolean bl3 = this.agent.stepHandler.notifyException(the_event, bl || bl2);
            if (!bl3 && (bl || bl2)) {
                this.agent.setSingleStep(Handler.the_event.thread, false);
                this.agent.suspendAllThreads();
                this.agent.reportAppException(the_event);
            }
        }
    }

    private void handleSingleStep() throws IOException {
        this.agent.setSingleStep(Handler.the_event.thread, false);
        this.agent.suspendAllThreads();
        Breakpoint breakpoint = Breakpoint.get(the_event.getMethod(), Handler.the_event.bci);
        if (breakpoint != null) {
            Agent.message("Step/break at same location, resuming until breakpoint is hit");
            this.agent.resumeLastSuspendedThreads();
        } else {
            boolean bl = this.agent.stepHandler.notifyBreak(the_event);
            if (!bl) {
                this.agent.reportBreakpoint(the_event);
            }
        }
    }

    synchronized void ignoreExceptionClass(Class clazz) {
        this.catchHash.remove(clazz);
    }

    public void run() {
        try {
            block20: while (true) {
                Event event = the_event;
                synchronized (event) {
                    Handler.the_event.waiting_for_event = true;
                    the_event.notifyAll();
                    if (!the_event.nextEvent()) {
                        Object var2_4 = null;
                        return;
                    }
                }
                if (this.agent.asyncOutputStream == null || Agent.systemThread(Handler.the_event.thread) || this.agent.debuggerTerminating) continue;
                Agent.message("Handler - " + the_event);
                switch (Handler.the_event.kind) {
                    case 4: {
                        this.handleException();
                        continue block20;
                    }
                    case 1: {
                        this.handleSingleStep();
                        continue block20;
                    }
                    case 2: {
                        this.handleBreakpoint();
                        continue block20;
                    }
                    case 6: {
                        Agent.message(the_event.toString());
                        continue block20;
                    }
                    case 7: {
                        this.agent.reportThreadEnd(the_event);
                        continue block20;
                    }
                    case 3: {
                        Agent.message(the_event.toString());
                        continue block20;
                    }
                }
                Agent.message("Received unhandled event: " + the_event);
            }
        }
        catch (ThreadDeath threadDeath) {
            Breakpoint.clearAllBreakpoints();
            Event event = the_event;
            synchronized (event) {
                Handler.the_event.waiting_for_event = true;
                the_event.notifyAll();
            }
            throw threadDeath;
        }
        catch (Exception exception) {
            Agent.error(Agent.exceptionStackTrace(exception));
            Breakpoint.clearAllBreakpoints();
            Event event = the_event;
            synchronized (event) {
                Handler.the_event.waiting_for_event = true;
                the_event.notifyAll();
            }
            return;
        }
    }
}

