/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import sun.tools.java.AmbiguousMember;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.MemberDefinition;
import sun.tools.java.MethodSet;
import sun.tools.java.Type;
import sun.tools.javac.SourceClass;
import sun.tools.javac.SourceMember;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.LocalMember;
import sun.tools.tree.UplevelReference;
import sun.tools.tree.Vset;

public class ClassDefinition
implements Constants {
    protected Object source;
    protected long where;
    protected int modifiers;
    protected Identifier localName;
    protected ClassDeclaration declaration;
    protected IdentifierToken superClassId;
    protected IdentifierToken[] interfaceIds;
    protected ClassDeclaration superClass;
    protected ClassDeclaration[] interfaces;
    protected ClassDefinition outerClass;
    protected MemberDefinition outerMember;
    protected MemberDefinition innerClassMember;
    protected MemberDefinition firstMember;
    protected MemberDefinition lastMember;
    protected boolean resolved;
    protected String documentation;
    protected boolean error;
    protected boolean nestError;
    protected UplevelReference references;
    protected boolean referencesFrozen;
    private Hashtable fieldHash = new Hashtable(31);
    private int abstr;
    private Hashtable localClasses = null;
    private final int LOCAL_CLASSES_SIZE = 31;
    protected Context classContext;
    protected boolean supersCheckStarted = this instanceof SourceClass ^ true;
    MethodSet allMethods = null;
    private List permanentlyAbstractMethods = new ArrayList();
    protected static boolean doInheritanceChecks = true;

    protected ClassDefinition(Object object, long l, ClassDeclaration classDeclaration, int n, IdentifierToken identifierToken, IdentifierToken[] identifierTokenArray) {
        this.source = object;
        this.where = l;
        this.declaration = classDeclaration;
        this.modifiers = n;
        this.superClassId = identifierToken;
        this.interfaceIds = identifierTokenArray;
    }

    public void addDependency(ClassDeclaration classDeclaration) {
        throw new CompilerError("addDependency");
    }

    public void addLocalClass(ClassDefinition classDefinition, String string) {
        if (this.localClasses == null) {
            this.localClasses = new Hashtable(31);
        }
        this.localClasses.put(string, classDefinition);
    }

    public void addMember(Environment environment, MemberDefinition memberDefinition) {
        this.addMember(memberDefinition);
        if (this.resolved) {
            memberDefinition.resolveTypeStructure(environment);
        }
    }

    public void addMember(MemberDefinition memberDefinition) {
        if (this.firstMember == null) {
            this.firstMember = this.lastMember = memberDefinition;
        } else if (memberDefinition.isSynthetic() && memberDefinition.isFinal() && memberDefinition.isVariable()) {
            memberDefinition.nextMember = this.firstMember;
            this.firstMember = memberDefinition;
            memberDefinition.nextMatch = (MemberDefinition)this.fieldHash.get(memberDefinition.name);
        } else {
            this.lastMember.nextMember = memberDefinition;
            this.lastMember = memberDefinition;
            memberDefinition.nextMatch = (MemberDefinition)this.fieldHash.get(memberDefinition.name);
        }
        this.fieldHash.put(memberDefinition.name, memberDefinition);
    }

    protected void addMirandaMethods(Environment environment, Iterator iterator) {
    }

    public final void addModifiers(int n) {
        this.modifiers |= n;
    }

    protected UplevelReference addReference(LocalMember localMember) {
        if (localMember.getClassDefinition() == this) {
            throw new CompilerError("addReference " + localMember);
        }
        this.referencesMustNotBeFrozen();
        UplevelReference uplevelReference = new UplevelReference(this, localMember);
        this.references = uplevelReference.insertInto(this.references);
        return uplevelReference;
    }

    protected void basicCheck(Environment environment) throws ClassNotFound {
        if (this.outerClass != null) {
            this.outerClass.basicCheck(environment);
        }
    }

    public boolean canAccess(Environment environment, ClassDeclaration classDeclaration) throws ClassNotFound {
        ClassDefinition classDefinition = classDeclaration.getClassDefinition(environment);
        if (classDefinition.isLocal()) {
            return true;
        }
        if (classDefinition.isInnerClass()) {
            return this.canAccess(environment, classDefinition.getInnerClassMember());
        }
        if (classDefinition.isPublic()) {
            return true;
        }
        return this.getName().getQualifier().equals(classDeclaration.getName().getQualifier());
    }

    public boolean canAccess(Environment environment, MemberDefinition memberDefinition) throws ClassNotFound {
        if (memberDefinition.isPublic()) {
            return true;
        }
        if (memberDefinition.isProtected() && this.subClassOf(environment, memberDefinition.getClassDeclaration())) {
            return true;
        }
        if (memberDefinition.isPrivate()) {
            return this.getTopClass().getClassDeclaration().equals(memberDefinition.getTopClass().getClassDeclaration());
        }
        return this.getName().getQualifier().equals(memberDefinition.getClassDeclaration().getName().getQualifier());
    }

    public void check(Environment environment) throws ClassNotFound {
    }

    public Vset checkLocalClass(Environment environment, Context context, Vset vset, ClassDefinition classDefinition, Expression[] expressionArray, Type[] typeArray) throws ClassNotFound {
        throw new CompilerError("checkLocalClass");
    }

    public void cleanup(Environment environment) {
        if (environment.dump()) {
            environment.output("[cleanup " + this.getName() + "]");
        }
        MemberDefinition memberDefinition = this.getFirstMember();
        while (memberDefinition != null) {
            memberDefinition.cleanup(environment);
            memberDefinition = memberDefinition.getNextMember();
        }
        this.documentation = null;
    }

    protected void collectInheritedMethods(Environment environment) {
        if (this.allMethods != null) {
            if (this.allMethods.isFrozen()) {
                return;
            }
            throw new CompilerError("collectInheritedMethods()");
        }
        MethodSet methodSet = new MethodSet();
        this.allMethods = new MethodSet();
        MethodSet methodSet2 = environment.version12() ? null : new MethodSet();
        MemberDefinition memberDefinition = this.getFirstMember();
        while (memberDefinition != null) {
            if (memberDefinition.isMethod() && !memberDefinition.isInitializer()) {
                methodSet.add(memberDefinition);
                this.allMethods.add(memberDefinition);
            }
            memberDefinition = memberDefinition.nextMember;
        }
        ClassDeclaration classDeclaration = this.getSuperClass(environment);
        if (classDeclaration != null) {
            this.collectOneClass(environment, classDeclaration, methodSet, this.allMethods, methodSet2);
            ClassDefinition classDefinition = classDeclaration.getClassDefinition();
            Iterator iterator = classDefinition.getPermanentlyAbstractMethods();
            while (iterator.hasNext()) {
                this.permanentlyAbstractMethods.add(iterator.next());
            }
        }
        int n = 0;
        while (n < this.interfaces.length) {
            this.collectOneClass(environment, this.interfaces[n], methodSet, this.allMethods, methodSet2);
            ++n;
        }
        this.allMethods.freeze();
        if (methodSet2 != null && methodSet2.size() > 0) {
            this.addMirandaMethods(environment, methodSet2.iterator());
        }
    }

    private void collectOneClass(Environment environment, ClassDeclaration classDeclaration, MethodSet methodSet, MethodSet methodSet2, MethodSet methodSet3) {
        try {
            ClassDefinition classDefinition = classDeclaration.getClassDefinition(environment);
            Iterator iterator = classDefinition.getMethods(environment);
            while (iterator.hasNext()) {
                MemberDefinition memberDefinition = (MemberDefinition)iterator.next();
                if (memberDefinition.isPrivate() || memberDefinition.isConstructor() || classDefinition.isInterface() && !memberDefinition.isAbstract()) continue;
                Identifier identifier = memberDefinition.getName();
                Type type = memberDefinition.getType();
                MemberDefinition memberDefinition2 = methodSet.lookupSig(identifier, type);
                if (memberDefinition.isPackagePrivate() && !this.inSamePackage(memberDefinition.getClassDeclaration())) {
                    if (memberDefinition2 != null && this instanceof SourceClass) {
                        environment.error(memberDefinition.getWhere(), "warn.no.override.access", memberDefinition2, memberDefinition2.getClassDeclaration(), memberDefinition.getClassDeclaration());
                    }
                    if (!memberDefinition.isAbstract()) continue;
                    this.permanentlyAbstractMethods.add(memberDefinition);
                    continue;
                }
                if (memberDefinition2 != null) {
                    memberDefinition2.checkOverride(environment, memberDefinition);
                    continue;
                }
                MemberDefinition memberDefinition3 = methodSet2.lookupSig(identifier, type);
                if (memberDefinition3 == null) {
                    if (methodSet3 != null && classDefinition.isInterface() && !this.isInterface()) {
                        memberDefinition = new SourceMember(memberDefinition, this, environment);
                        methodSet3.add(memberDefinition);
                    }
                    methodSet2.add(memberDefinition);
                    continue;
                }
                if (this.isInterface() && !memberDefinition3.isAbstract() && memberDefinition.isAbstract()) {
                    methodSet2.replace(memberDefinition);
                    continue;
                }
                if (!memberDefinition3.checkMeet(environment, memberDefinition, this.getClassDeclaration()) || memberDefinition3.couldOverride(environment, memberDefinition)) continue;
                if (memberDefinition.couldOverride(environment, memberDefinition3)) {
                    if (methodSet3 != null && classDefinition.isInterface() && !this.isInterface()) {
                        memberDefinition = new SourceMember(memberDefinition, this, environment);
                        methodSet3.replace(memberDefinition);
                    }
                    methodSet2.replace(memberDefinition);
                    continue;
                }
                environment.error(this.where, "nontrivial.meet", memberDefinition, memberDefinition3.getClassDefinition(), memberDefinition.getClassDeclaration());
            }
        }
        catch (ClassNotFound classNotFound) {
            environment.error(this.getWhere(), "class.not.found", classNotFound.name, this);
        }
    }

    public static boolean containsDeprecated(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while ((n = string.indexOf("@deprecated", n)) >= 0) {
            block5: {
                char c;
                char c2;
                int n2 = n - 1;
                while (n2 >= 0) {
                    c2 = string.charAt(n2);
                    if (c2 == '\n' || c2 == '\r') break;
                    if (Character.isSpace(c2)) {
                        --n2;
                        continue;
                    }
                    break block5;
                }
                if ((c2 = n + "@deprecated".length()) >= string.length() || (c = string.charAt(c2)) == '\n' || c == '\r' || Character.isSpace(c)) {
                    return true;
                }
            }
            n += "@deprecated".length();
        }
        return false;
    }

    public boolean couldImplement(ClassDefinition classDefinition) {
        if (!doInheritanceChecks) {
            throw new CompilerError("couldImplement: no checks");
        }
        if (!this.isInterface() || !classDefinition.isInterface()) {
            throw new CompilerError("couldImplement: not interface");
        }
        if (this.allMethods == null) {
            throw new CompilerError("couldImplement: called early");
        }
        Iterator iterator = classDefinition.getMethods();
        while (iterator.hasNext()) {
            Type type;
            MemberDefinition memberDefinition = (MemberDefinition)iterator.next();
            Identifier identifier = memberDefinition.getName();
            MemberDefinition memberDefinition2 = this.allMethods.lookupSig(identifier, type = memberDefinition.getType());
            if (memberDefinition2 == null || memberDefinition2.sameReturnType(memberDefinition)) continue;
            return false;
        }
        return true;
    }

    private boolean diagnoseMismatch(Environment environment, Identifier identifier, Type[] typeArray, int n, int[] nArray, Type[] typeArray2) throws ClassNotFound {
        Type[] typeArray3;
        boolean bl = false;
        MemberDefinition memberDefinition = this.getFirstMatch(identifier);
        while (memberDefinition != null) {
            block11: {
                if (!memberDefinition.isMethod() || (typeArray3 = memberDefinition.getType().getArgumentTypes()).length != typeArray.length) break block11;
                bl = true;
                int n2 = n;
                while (n2 < typeArray.length) {
                    block13: {
                        Type type;
                        block15: {
                            block14: {
                                Type type2;
                                block12: {
                                    type2 = typeArray[n2];
                                    type = typeArray3[n2];
                                    if (!environment.implicitCast(type2, type)) break block12;
                                    nArray[n2] = 4;
                                    break block13;
                                }
                                if (nArray[n2] > 2 || !environment.explicitCast(type2, type)) break block14;
                                if (nArray[n2] < 2) {
                                    typeArray2[n2] = null;
                                }
                                nArray[n2] = 2;
                                break block15;
                            }
                            if (nArray[n2] > 0) break block13;
                        }
                        if (typeArray2[n2] == null) {
                            typeArray2[n2] = type;
                        } else if (typeArray2[n2] != type) {
                            int n3 = n2;
                            nArray[n3] = nArray[n3] | 1;
                        }
                    }
                    ++n2;
                }
            }
            memberDefinition = memberDefinition.getNextMatch();
        }
        if (identifier.equals(Constants.idInit)) {
            return bl;
        }
        typeArray3 = this.getSuperClass();
        if (typeArray3 != null && typeArray3.getClassDefinition(environment).diagnoseMismatch(environment, identifier, typeArray, n, nArray, typeArray2)) {
            bl = true;
        }
        return bl;
    }

    public int diagnoseMismatch(Environment environment, Identifier identifier, Type[] typeArray, int n, Type[] typeArray2) throws ClassNotFound {
        int[] nArray = new int[typeArray.length];
        Type[] typeArray3 = new Type[typeArray.length];
        if (!this.diagnoseMismatch(environment, identifier, typeArray, n, nArray, typeArray3)) {
            return -2;
        }
        int n2 = n;
        while (n2 < typeArray.length) {
            if (nArray[n2] < 4) {
                typeArray2[0] = typeArray3[n2];
                return n2 << 2 | nArray[n2];
            }
            ++n2;
        }
        return -1;
    }

    public boolean enclosingClassOf(ClassDefinition classDefinition) {
        while ((classDefinition = classDefinition.getOuterClass()) != null) {
            if (this != classDefinition) continue;
            return true;
        }
        return false;
    }

    public boolean extendsCanAccess(Environment environment, ClassDeclaration classDeclaration) throws ClassNotFound {
        if (this.outerClass != null) {
            return this.outerClass.canAccess(environment, classDeclaration);
        }
        ClassDefinition classDefinition = classDeclaration.getClassDefinition(environment);
        if (classDefinition.isLocal()) {
            throw new CompilerError("top local");
        }
        if (classDefinition.isInnerClass()) {
            MemberDefinition memberDefinition = classDefinition.getInnerClassMember();
            if (memberDefinition.isPublic()) {
                return true;
            }
            if (memberDefinition.isPrivate()) {
                return this.getClassDeclaration().equals(memberDefinition.getTopClass().getClassDeclaration());
            }
            return this.getName().getQualifier().equals(memberDefinition.getClassDeclaration().getName().getQualifier());
        }
        if (classDefinition.isPublic()) {
            return true;
        }
        return this.getName().getQualifier().equals(classDeclaration.getName().getQualifier());
    }

    public MemberDefinition findAnyMethod(Environment environment, Identifier identifier) throws ClassNotFound {
        MemberDefinition memberDefinition = this.getFirstMatch(identifier);
        while (memberDefinition != null) {
            if (memberDefinition.isMethod()) {
                return memberDefinition;
            }
            memberDefinition = memberDefinition.getNextMatch();
        }
        ClassDeclaration classDeclaration = this.getSuperClass();
        if (classDeclaration == null) {
            return null;
        }
        return classDeclaration.getClassDefinition(environment).findAnyMethod(environment, identifier);
    }

    public MemberDefinition findMethod(Environment environment, Identifier identifier, Type type) throws ClassNotFound {
        MemberDefinition memberDefinition = this.getFirstMatch(identifier);
        while (memberDefinition != null) {
            if (memberDefinition.getType().equalArguments(type)) {
                return memberDefinition;
            }
            memberDefinition = memberDefinition.getNextMatch();
        }
        if (identifier.equals(Constants.idInit)) {
            return null;
        }
        ClassDeclaration classDeclaration = this.getSuperClass();
        if (classDeclaration == null) {
            return null;
        }
        return classDeclaration.getClassDefinition(environment).findMethod(environment, identifier, type);
    }

    public final MemberDefinition findOuterMember() {
        return this.outerMember;
    }

    public MemberDefinition getAccessMember(Environment environment, Context context, MemberDefinition memberDefinition, boolean bl) {
        throw new CompilerError("binary getAccessMember");
    }

    public Context getClassContext() {
        return this.classContext;
    }

    public final ClassDeclaration getClassDeclaration() {
        return this.declaration;
    }

    public MemberDefinition getClassLiteralLookup(long l) {
        throw new CompilerError("binary class");
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public final boolean getError() {
        return this.error;
    }

    public final MemberDefinition getFirstMatch(Identifier identifier) {
        return (MemberDefinition)this.fieldHash.get(identifier);
    }

    public final MemberDefinition getFirstMember() {
        return this.firstMember;
    }

    public MemberDefinition getInnerClass(Environment environment, Identifier identifier) throws ClassNotFound {
        MemberDefinition memberDefinition = this.getFirstMatch(identifier);
        while (memberDefinition != null) {
            if (memberDefinition.isInnerClass() && !memberDefinition.getInnerClass().isLocal()) {
                return memberDefinition;
            }
            memberDefinition = memberDefinition.getNextMatch();
        }
        ClassDeclaration classDeclaration = this.getSuperClass(environment);
        if (classDeclaration != null) {
            return classDeclaration.getClassDefinition(environment).getInnerClass(environment, identifier);
        }
        return null;
    }

    public final MemberDefinition getInnerClassMember() {
        if (this.outerClass == null) {
            return null;
        }
        if (this.innerClassMember == null) {
            Identifier identifier = this.getName().getFlatName().getName();
            MemberDefinition memberDefinition = this.outerClass.getFirstMatch(identifier);
            while (memberDefinition != null) {
                if (memberDefinition.isInnerClass()) {
                    this.innerClassMember = memberDefinition;
                    break;
                }
                memberDefinition = memberDefinition.getNextMatch();
            }
            if (this.innerClassMember == null) {
                throw new CompilerError("getInnerClassField");
            }
        }
        return this.innerClassMember;
    }

    public final ClassDeclaration[] getInterfaces() {
        if (this.interfaces == null) {
            throw new CompilerError("getInterfaces");
        }
        return this.interfaces;
    }

    public ClassDefinition getLocalClass(String string) {
        if (this.localClasses == null) {
            return null;
        }
        return (ClassDefinition)this.localClasses.get(string);
    }

    public Identifier getLocalName() {
        if (this.localName != null) {
            return this.localName;
        }
        return this.getName().getFlatName().getName();
    }

    public Iterator getMethods() {
        if (this.allMethods == null) {
            throw new CompilerError("getMethods: too early");
        }
        return this.allMethods.iterator();
    }

    public Iterator getMethods(Environment environment) {
        if (this.allMethods == null) {
            this.collectInheritedMethods(environment);
        }
        return this.getMethods();
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final Identifier getName() {
        return this.declaration.getName();
    }

    public final boolean getNestError() {
        return this.nestError || this.outerClass != null && this.outerClass.getNestError();
    }

    public final ClassDefinition getOuterClass() {
        return this.outerClass;
    }

    protected Iterator getPermanentlyAbstractMethods() {
        if (this.allMethods == null) {
            throw new CompilerError("isPermanentlyAbstract() called early");
        }
        return this.permanentlyAbstractMethods.iterator();
    }

    public UplevelReference getReference(LocalMember localMember) {
        UplevelReference uplevelReference = this.references;
        while (uplevelReference != null) {
            if (uplevelReference.getTarget() == localMember) {
                return uplevelReference;
            }
            uplevelReference = uplevelReference.getNext();
        }
        return this.addReference(localMember);
    }

    public UplevelReference getReferences() {
        return this.references;
    }

    public UplevelReference getReferencesFrozen() {
        this.referencesFrozen = true;
        return this.references;
    }

    public final Object getSource() {
        return this.source;
    }

    public final ClassDeclaration getSuperClass() {
        if (!this.supersCheckStarted) {
            throw new CompilerError("unresolved super");
        }
        return this.superClass;
    }

    public ClassDeclaration getSuperClass(Environment environment) {
        return this.getSuperClass();
    }

    public final ClassDefinition getTopClass() {
        ClassDefinition classDefinition;
        ClassDefinition classDefinition2 = this;
        while ((classDefinition = classDefinition2.outerClass) != null) {
            classDefinition2 = classDefinition;
        }
        return classDefinition2;
    }

    public final Type getType() {
        return this.declaration.getType();
    }

    public MemberDefinition getUpdateMember(Environment environment, Context context, MemberDefinition memberDefinition, boolean bl) {
        throw new CompilerError("binary getUpdateMember");
    }

    public MemberDefinition getVariable(Environment environment, Identifier identifier, ClassDefinition classDefinition) throws AmbiguousMember, ClassNotFound {
        return this.getVariable0(environment, identifier, classDefinition, true, true);
    }

    private MemberDefinition getVariable0(Environment environment, Identifier identifier, ClassDefinition classDefinition, boolean bl, boolean bl2) throws AmbiguousMember, ClassNotFound {
        MemberDefinition memberDefinition = this.getFirstMatch(identifier);
        while (memberDefinition != null) {
            if (memberDefinition.isVariable()) {
                if (!(!bl && memberDefinition.isPrivate() || !bl2 && memberDefinition.isPackagePrivate())) {
                    return memberDefinition;
                }
                return null;
            }
            memberDefinition = memberDefinition.getNextMatch();
        }
        ClassDeclaration classDeclaration = this.getSuperClass();
        MemberDefinition memberDefinition2 = null;
        if (classDeclaration != null) {
            memberDefinition2 = classDeclaration.getClassDefinition(environment).getVariable0(environment, identifier, classDefinition, false, bl2 && this.inSamePackage(classDeclaration));
        }
        int n = 0;
        while (n < this.interfaces.length) {
            MemberDefinition memberDefinition3 = this.interfaces[n].getClassDefinition(environment).getVariable0(environment, identifier, classDefinition, true, true);
            if (memberDefinition3 != null) {
                if (memberDefinition2 != null && classDefinition.canAccess(environment, memberDefinition2) && memberDefinition3 != memberDefinition2) {
                    throw new AmbiguousMember(memberDefinition3, memberDefinition2);
                }
                memberDefinition2 = memberDefinition3;
            }
            ++n;
        }
        return memberDefinition2;
    }

    public final long getWhere() {
        return this.where;
    }

    public final boolean hasConstructor() {
        return this.getFirstMatch(Constants.idInit) != null;
    }

    public boolean implementedBy(Environment environment, ClassDeclaration classDeclaration) throws ClassNotFound {
        while (classDeclaration != null) {
            if (this.getClassDeclaration().equals(classDeclaration)) {
                return true;
            }
            ClassDeclaration[] classDeclarationArray = classDeclaration.getClassDefinition(environment).getInterfaces();
            int n = 0;
            while (n < classDeclarationArray.length) {
                if (this.implementedBy(environment, classDeclarationArray[n])) {
                    return true;
                }
                ++n;
            }
            classDeclaration = classDeclaration.getClassDefinition(environment).getSuperClass();
        }
        return false;
    }

    public final boolean inSamePackage(ClassDeclaration classDeclaration) {
        return this.inSamePackage(classDeclaration.getName().getQualifier());
    }

    public final boolean inSamePackage(ClassDefinition classDefinition) {
        return this.inSamePackage(classDefinition.getName().getQualifier());
    }

    public final boolean inSamePackage(Identifier identifier) {
        return this.getName().getQualifier().equals(identifier);
    }

    public void inlineLocalClass(Environment environment) {
    }

    public boolean innerClassExists(Identifier identifier) {
        MemberDefinition memberDefinition = this.getFirstMatch(identifier.getHead());
        while (memberDefinition != null) {
            if (memberDefinition.isInnerClass() && !memberDefinition.getInnerClass().isLocal()) {
                return !identifier.isQualified() || memberDefinition.getInnerClass().innerClassExists(identifier.getTail());
            }
            memberDefinition = memberDefinition.getNextMatch();
        }
        return false;
    }

    public final boolean isAbstract() {
        return (this.getModifiers() & 0x400) != 0;
    }

    public final boolean isAnonymous() {
        return (this.getModifiers() & 0x10000) != 0;
    }

    public final boolean isClass() {
        return (this.getModifiers() & 0x200) == 0;
    }

    public final boolean isDeprecated() {
        return (this.getModifiers() & 0x40000) != 0;
    }

    public final boolean isFinal() {
        return (this.getModifiers() & 0x10) != 0;
    }

    public final boolean isInnerClass() {
        return this.outerClass != null;
    }

    public final boolean isInsideLocal() {
        return this.isLocal() || this.outerClass != null && this.outerClass.isInsideLocal();
    }

    public final boolean isInsideLocalOrAnonymous() {
        return this.isLocal() || this.isAnonymous() || this.outerClass != null && this.outerClass.isInsideLocalOrAnonymous();
    }

    public final boolean isInterface() {
        return (this.getModifiers() & 0x200) != 0;
    }

    public final boolean isLocal() {
        return (this.getModifiers() & 0x20000) != 0;
    }

    public final boolean isMember() {
        return this.outerClass != null && !this.isLocal();
    }

    public final boolean isPackagePrivate() {
        return (this.modifiers & 7) == 0;
    }

    public final boolean isPrivate() {
        return (this.getModifiers() & 2) != 0;
    }

    public final boolean isProtected() {
        return (this.getModifiers() & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.getModifiers() & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isSynthetic() {
        return (this.getModifiers() & 0x80000) != 0;
    }

    public final boolean isTopLevel() {
        return this.outerClass == null || this.isStatic() || this.isInterface();
    }

    public MemberDefinition matchAnonConstructor(Environment environment, Identifier identifier, Type[] typeArray) throws AmbiguousMember, ClassNotFound {
        return this.matchMethod(environment, null, Constants.idInit, typeArray, true, identifier);
    }

    public MemberDefinition matchMethod(Environment environment, ClassDefinition classDefinition, Identifier identifier) throws AmbiguousMember, ClassNotFound {
        return this.matchMethod(environment, classDefinition, identifier, Type.noArgs, false, null);
    }

    public MemberDefinition matchMethod(Environment environment, ClassDefinition classDefinition, Identifier identifier, Type[] typeArray) throws AmbiguousMember, ClassNotFound {
        return this.matchMethod(environment, classDefinition, identifier, typeArray, false, null);
    }

    private MemberDefinition matchMethod(Environment environment, ClassDefinition classDefinition, Identifier identifier, Type[] typeArray, boolean bl, Identifier identifier2) throws AmbiguousMember, ClassNotFound {
        Object object;
        if (this.allMethods == null || !this.allMethods.isFrozen()) {
            throw new CompilerError("matchMethod called early");
        }
        Object object2 = null;
        ArrayList<Object> arrayList = null;
        Iterator iterator = this.allMethods.lookupName(identifier);
        while (iterator.hasNext()) {
            object = (MemberDefinition)iterator.next();
            if (!environment.isApplicable((MemberDefinition)object, typeArray) || (classDefinition == null ? bl && (((MemberDefinition)object).isPrivate() || ((MemberDefinition)object).isPackagePrivate() && identifier2 != null && !this.inSamePackage(identifier2)) : !classDefinition.canAccess(environment, (MemberDefinition)object))) continue;
            if (object2 == null) {
                object2 = object;
                continue;
            }
            if (environment.isMoreSpecific((MemberDefinition)object, (MemberDefinition)object2)) {
                object2 = object;
                continue;
            }
            if (environment.isMoreSpecific((MemberDefinition)object2, (MemberDefinition)object)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
            }
            arrayList.add(object);
        }
        if (object2 != null && arrayList != null) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                MemberDefinition memberDefinition = (MemberDefinition)object.next();
                if (environment.isMoreSpecific((MemberDefinition)object2, memberDefinition)) continue;
                throw new AmbiguousMember((MemberDefinition)object2, memberDefinition);
            }
        }
        return object2;
    }

    public final boolean mustBeAbstract(Environment environment) {
        if (this.isAbstract()) {
            return true;
        }
        this.collectInheritedMethods(environment);
        Iterator iterator = this.getMethods();
        while (iterator.hasNext()) {
            MemberDefinition memberDefinition = (MemberDefinition)iterator.next();
            if (!memberDefinition.isAbstract()) continue;
            return true;
        }
        return this.getPermanentlyAbstractMethods().hasNext();
    }

    public void noteUsedBy(ClassDefinition classDefinition, long l, Environment environment) {
        if (this.reportDeprecated(environment)) {
            environment.error(l, "warn.class.is.deprecated", this);
        }
    }

    public boolean permitInlinedAccess(Environment environment, ClassDeclaration classDeclaration) throws ClassNotFound {
        return environment.opt() && classDeclaration.equals(this.declaration) || environment.opt_interclass() && this.canAccess(environment, classDeclaration);
    }

    public boolean permitInlinedAccess(Environment environment, MemberDefinition memberDefinition) throws ClassNotFound {
        return environment.opt() && memberDefinition.clazz.getClassDeclaration().equals(this.declaration) || environment.opt_interclass() && this.canAccess(environment, memberDefinition);
    }

    public void print(PrintStream printStream) {
        if (this.isPublic()) {
            printStream.print("public ");
        }
        if (this.isInterface()) {
            printStream.print("interface ");
        } else {
            printStream.print("class ");
        }
        printStream.print(String.valueOf(String.valueOf(this.getName())) + " ");
        if (this.getSuperClass() != null) {
            printStream.print("extends " + this.getSuperClass().getName() + " ");
        }
        if (this.interfaces.length > 0) {
            printStream.print("implements ");
            int n = 0;
            while (n < this.interfaces.length) {
                if (n > 0) {
                    printStream.print(", ");
                }
                printStream.print(this.interfaces[n].getName());
                printStream.print(" ");
                ++n;
            }
        }
        printStream.println("{");
        MemberDefinition memberDefinition = this.getFirstMember();
        while (memberDefinition != null) {
            printStream.print("    ");
            memberDefinition.print(printStream);
            memberDefinition = memberDefinition.getNextMember();
        }
        printStream.println("}");
    }

    public boolean protectedAccess(Environment environment, MemberDefinition memberDefinition, Type type) throws ClassNotFound {
        return memberDefinition.isStatic() || type.isType(9) && memberDefinition.getName() == Constants.idClone && memberDefinition.getType().getArgumentTypes().length == 0 || type.isType(10) && environment.getClassDefinition(type.getClassName()).subClassOf(environment, this.getClassDeclaration()) || this.getName().getQualifier().equals(memberDefinition.getClassDeclaration().getName().getQualifier());
    }

    public final void referencesMustNotBeFrozen() {
        if (this.referencesFrozen) {
            throw new CompilerError("referencesMustNotBeFrozen " + this);
        }
    }

    public boolean reportDeprecated(Environment environment) {
        return this.isDeprecated() || this.outerClass != null && this.outerClass.reportDeprecated(environment);
    }

    public Identifier resolveInnerClass(Environment environment, Identifier identifier) {
        if (identifier.isInner()) {
            throw new CompilerError("inner");
        }
        if (identifier.isQualified()) {
            Identifier identifier2 = this.resolveInnerClass(environment, identifier.getHead());
            try {
                return environment.getClassDefinition(identifier2).resolveInnerClass(environment, identifier.getTail());
            }
            catch (ClassNotFound classNotFound) {
                return Identifier.lookupInner(identifier2, identifier.getTail());
            }
        }
        try {
            MemberDefinition memberDefinition = this.getInnerClass(environment, identifier);
            if (memberDefinition != null) {
                return memberDefinition.getInnerClass().getName();
            }
        }
        catch (ClassNotFound classNotFound) {}
        return Identifier.lookupInner(this.getName(), identifier);
    }

    public Identifier resolveName(Environment environment, Identifier identifier) {
        environment.dtEvent("ClassDefinition.resolveName: " + identifier);
        if (identifier.isQualified()) {
            Identifier identifier2 = this.resolveName(environment, identifier.getHead());
            if (identifier2.hasAmbigPrefix()) {
                return identifier2;
            }
            if (!environment.classExists(identifier2)) {
                return environment.resolvePackageQualifiedName(identifier);
            }
            try {
                return environment.getClassDefinition(identifier2).resolveInnerClass(environment, identifier.getTail());
            }
            catch (ClassNotFound classNotFound) {
                return Identifier.lookupInner(identifier2, identifier.getTail());
            }
        }
        int n = -2;
        LocalMember localMember = null;
        if (this.classContext != null && (localMember = this.classContext.getLocalClass(identifier)) != null) {
            n = localMember.getScopeNumber();
        }
        ClassDefinition classDefinition = this;
        while (classDefinition != null) {
            try {
                MemberDefinition memberDefinition = classDefinition.getInnerClass(environment, identifier);
                if (memberDefinition != null && (localMember == null || this.classContext.getScopeNumber(classDefinition) > n)) {
                    return memberDefinition.getInnerClass().getName();
                }
            }
            catch (ClassNotFound classNotFound) {}
            classDefinition = classDefinition.outerClass;
        }
        if (localMember != null) {
            return localMember.getInnerClass().getName();
        }
        return environment.resolveName(identifier);
    }

    public void resolveTypeStructure(Environment environment) {
    }

    public final void setError() {
        this.error = true;
        this.setNestError();
    }

    public void setLocalName(Identifier identifier) {
        if (this.isLocal()) {
            this.localName = identifier;
        }
    }

    public final void setNestError() {
        this.nestError = true;
        if (this.outerClass != null) {
            this.outerClass.setNestError();
        }
    }

    protected final void setOuterClass(ClassDefinition classDefinition) {
        if (this.outerClass != null) {
            throw new CompilerError("setOuterClass");
        }
        this.outerClass = classDefinition;
    }

    protected final void setOuterMember(MemberDefinition memberDefinition) {
        if (this.isStatic() || !this.isInnerClass()) {
            throw new CompilerError("setOuterField");
        }
        if (this.outerMember != null) {
            throw new CompilerError("setOuterField");
        }
        this.outerMember = memberDefinition;
    }

    public boolean subClassOf(Environment environment, ClassDeclaration classDeclaration) throws ClassNotFound {
        ClassDeclaration classDeclaration2 = this.getClassDeclaration();
        while (classDeclaration2 != null) {
            if (classDeclaration2.equals(classDeclaration)) {
                return true;
            }
            classDeclaration2 = classDeclaration2.getClassDefinition(environment).getSuperClass();
        }
        return false;
    }

    public final void subModifiers(int n) {
        this.modifiers &= ~n;
    }

    public boolean superClassOf(Environment environment, ClassDeclaration classDeclaration) throws ClassNotFound {
        while (classDeclaration != null) {
            if (this.getClassDeclaration().equals(classDeclaration)) {
                return true;
            }
            classDeclaration = classDeclaration.getClassDefinition(environment).getSuperClass();
        }
        return false;
    }

    public String toString() {
        return this.getClassDeclaration().toString();
    }

    public static void turnOffInheritanceChecks() {
        doInheritanceChecks = false;
    }
}

