/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.moo;

import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tools.moo.ParameterizedTest;
import org.apache.tools.moo.TestResult;
import org.apache.tools.moo.Testable;

public class RunTest {
    String host = "localhost";
    int port = 8080;
    boolean debug = true;
    String testClassName;
    String testKey = null;

    private void doTest() throws Exception {
        Testable testable = null;
        try {
            testable = (Testable)Class.forName(this.testClassName).newInstance();
            if (testable instanceof ParameterizedTest) {
                ((ParameterizedTest)testable).setKey(this.testKey);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        TestResult testResult = null;
        String string = null;
        boolean bl = false;
        FileOutputStream fileOutputStream = new FileOutputStream("errorLog");
        try {
            testable.setStream(fileOutputStream);
            string = testable.getDescription();
            testResult = testable.runTest();
            bl = testResult.getStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("OK  ");
        } else {
            stringBuffer.append("FAIL");
        }
        stringBuffer.append(" ").append(this.testClassName).append(" (");
        stringBuffer.append(string).append(") :");
        if (testResult == null) {
            System.out.println("BAD TEST - returns null");
            return;
        }
        String string2 = testResult.getMessage();
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        System.out.println(stringBuffer);
    }

    public static void main(String[] stringArray) {
        try {
            RunTest runTest = new RunTest();
            runTest.run(stringArray);
        }
        catch (Exception exception) {
            System.out.println("Error in RunTest:");
            exception.printStackTrace();
        }
    }

    private void processArgs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.equals("-h")) {
                this.host = stringArray[++n];
            } else {
                if (string.equals("-?")) {
                    System.out.println("Usage: RunTest [-d] [-p port] [-h host] class ");
                    return;
                }
                if (string.equals("-d")) {
                    this.debug = true;
                } else if (string.equals("-p")) {
                    String string2 = stringArray[++n];
                    this.port = Integer.valueOf(string2);
                } else if (string.equals("-key")) {
                    this.testKey = stringArray[++n];
                } else {
                    this.testClassName = string;
                }
            }
            ++n;
        }
    }

    void run(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        this.processArgs(stringArray);
        this.setDefaults();
        this.doTest();
        long l2 = System.currentTimeMillis() - l;
    }

    private void setDefaults() {
        try {
            Properties properties = new Properties();
            properties = System.getProperties();
            ((Hashtable)properties).put("test.hostName", this.host);
            ((Hashtable)properties).put("test.port", new Integer(this.port).toString());
            System.setProperties(properties);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
    }
}

