/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.moo.jsp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.moo.Logger;
import org.apache.tools.moo.TestResult;
import org.apache.tools.moo.Testable;
import org.apache.tools.moo.URLHelper;
import org.apache.tools.moo.jsp.MapManager;
import org.apache.tools.moo.jsp.MapManagerImpl;

public abstract class JspCheckTest
implements Testable {
    MapManager mapManager;
    URL url = null;
    boolean useCookie = false;
    protected Logger out = Logger.getLogger();

    private void doHeaders(Hashtable hashtable, HttpURLConnection httpURLConnection) {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2 = (String)enumeration.nextElement();
                if (!(string2 != null & (string = (String)hashtable.get(string2)) != null)) continue;
                httpURLConnection.setRequestProperty(string2, string);
            }
        }
    }

    private String doQueryString(Hashtable hashtable) {
        if (hashtable == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = new Vector();
            vector.addElement(hashtable.get(string));
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                if (stringBuffer.length() == 0) {
                    stringBuffer.append("?");
                }
                stringBuffer.append(URLEncoder.encode(string));
                stringBuffer.append("=");
                stringBuffer.append(URLEncoder.encode(string2));
            }
        }
        return stringBuffer.toString();
    }

    public HttpURLConnection getCon(Hashtable hashtable, String string, String string2, String string3) throws Exception {
        HttpURLConnection httpURLConnection = null;
        String string4 = this.getClass().getName();
        this.mapManager = MapManagerImpl.getMapManager();
        String string5 = this.mapManager.get(string4);
        if (string5 == null) {
            throw new NullPointerException("bad resource: " + string4 + ".  Can't map client test to server test");
        }
        String string6 = String.valueOf(string5) + (string2 != null ? "/" + string2 : "") + string;
        this.url = URLHelper.getURL(string6);
        String string7 = this.url.getHost();
        String string8 = String.valueOf(this.url.getPort());
        String string9 = this.url.getProtocol();
        String string10 = this.url.getFile();
        try {
            httpURLConnection = (HttpURLConnection)this.url.openConnection();
        }
        catch (IOException iOException) {
            this.out.println("Could not retrieve file " + string10 + " on " + string7 + " on port number " + string8 + " via " + string9 + " protocol");
            throw iOException;
        }
        if (string3 != null) {
            try {
                httpURLConnection.setRequestMethod(string3);
            }
            catch (ProtocolException protocolException) {
                this.out.println("Method: " + string3 + " not valid for " + string9);
                throw protocolException;
            }
        }
        if (this.useCookie) {
            this.setCookieHeader(httpURLConnection);
        }
        this.doHeaders(hashtable, httpURLConnection);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setUseCaches(false);
        HttpURLConnection.setFollowRedirects(false);
        try {
            httpURLConnection.connect();
        }
        catch (IOException iOException) {
            this.out.println("Could not establish a connection to file " + string10 + " on " + string7 + " on port number " + string8 + " via " + string9 + " protocol");
            throw iOException;
        }
        this.out.println("Connected to " + this.url.toString());
        return httpURLConnection;
    }

    public HttpURLConnection getCon(Hashtable hashtable, String string, String string2, String string3, boolean bl) throws Exception {
        this.useCookie = bl;
        return this.getCon(hashtable, string, string2, string3);
    }

    public HttpURLConnection getConnection() throws Exception {
        return this.getConnection(null, null, null, null);
    }

    public HttpURLConnection getConnection(String string) throws Exception {
        return this.getConnection(null, null, null, string);
    }

    public HttpURLConnection getConnection(String string, boolean bl) throws Exception {
        this.useCookie = bl;
        return this.getConnection(null, null, null, string);
    }

    public HttpURLConnection getConnection(Hashtable hashtable) throws Exception {
        return this.getConnection(hashtable, null, null, null);
    }

    public HttpURLConnection getConnection(Hashtable hashtable, Hashtable hashtable2, String string) throws Exception {
        return this.getConnection(hashtable, hashtable2, string, null);
    }

    public HttpURLConnection getConnection(Hashtable hashtable, Hashtable hashtable2, String string, String string2) throws Exception {
        return this.getCon(hashtable, this.doQueryString(hashtable2), string, string2);
    }

    public HttpURLConnection getConnection(Hashtable hashtable, Hashtable hashtable2, String string, String string2, boolean bl) throws Exception {
        this.useCookie = bl;
        return this.getCon(hashtable, this.doQueryString(hashtable2), string, string2);
    }

    public HttpURLConnection getConnection(Hashtable hashtable, Hashtable hashtable2, String string, boolean bl) throws Exception {
        this.useCookie = bl;
        return this.getConnection(hashtable, hashtable2, string, null);
    }

    public HttpURLConnection getConnection(Hashtable hashtable, boolean bl) throws Exception {
        this.useCookie = bl;
        return this.getConnection(hashtable, null, null, null);
    }

    public HttpURLConnection getConnection(boolean bl) throws Exception {
        this.useCookie = bl;
        return this.getConnection(null, null, null, null);
    }

    public abstract String getDescription();

    public HttpURLConnection getQueryConnection(Hashtable hashtable, String string, String string2, String string3) throws Exception {
        return this.getCon(hashtable, "?" + string, string2, string3);
    }

    public HttpURLConnection getQueryConnection(Hashtable hashtable, String string, String string2, String string3, boolean bl) throws Exception {
        this.useCookie = bl;
        return this.getCon(hashtable, "?" + string, string2, string3);
    }

    public TestResult getTestResult(HttpURLConnection httpURLConnection) throws Exception {
        TestResult testResult = new TestResult();
        Properties properties = new Properties();
        int n = httpURLConnection.getResponseCode();
        String string = httpURLConnection.getResponseMessage();
        if (this.useCookie) {
            this.saveCookies(httpURLConnection);
        }
        if (n >= 400) {
            testResult.setStatus(false);
            testResult.setMessage(string);
        } else {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                this.out.println(string2);
            }
            httpURLConnection.disconnect();
            String string3 = properties.getProperty("Status", "false");
            this.out.println("Status: " + string3);
            if (string3.equals("false")) {
                this.out.println(properties.getProperty("Message", ""));
            }
            testResult.setStatus(Boolean.valueOf(string3));
            testResult.setMessage(properties.getProperty("Message", ""));
        }
        return testResult;
    }

    public TestResult getTestResult(TestResult testResult, Exception exception) {
        if (testResult == null) {
            testResult = new TestResult();
        }
        testResult.setStatus(false);
        testResult.setMessage(String.valueOf(this.getClass().getName()) + " exception: " + exception);
        return testResult;
    }

    public abstract TestResult runTest();

    protected void saveCookies(HttpURLConnection httpURLConnection) {
        int n = 1;
        while (true) {
            block3: {
                try {
                    if (!((URLConnection)httpURLConnection).getHeaderFieldKey(n).equals("Set-Cookie")) break block3;
                    this.mapManager.getCookieManager().addCookieFromHeader(((URLConnection)httpURLConnection).getHeaderField(n), this.url);
                }
                catch (NullPointerException nullPointerException) {
                    break;
                }
            }
            ++n;
        }
    }

    protected void setCookieHeader(HttpURLConnection httpURLConnection) {
        String string = this.mapManager.getCookieManager().getCookieHeaderForURL(this.url);
        if (string != null) {
            httpURLConnection.setRequestProperty("Cookie", string);
        }
    }

    public void setStream(OutputStream outputStream) {
        this.out.setOutputStream(outputStream);
    }
}

