/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.task;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class GTest {
    String prefix = "http://localhost:8080/test";
    String host = "localhost";
    int port = 8080;
    int debug;
    String description = "No description";
    String request;
    Hashtable requestHeaders;
    String content;
    boolean magnitude = true;
    boolean exactMatch = false;
    String goldenFile;
    String responseMatch;
    Hashtable expectHeaders;
    String returnCode = "";
    String responseLine;
    String responseBody;
    Hashtable headers;

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(String string) {
        this.port = Integer.valueOf(string);
    }

    public void setExactMatch(String string) {
        this.exactMatch = Boolean.valueOf(string);
    }

    public void setPortInt(int n) {
        this.port = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void setDebug(String string) {
        this.debug = Integer.valueOf(string);
    }

    public void setMagnitude(String string) {
        this.magnitude = Boolean.valueOf(string);
    }

    public void setGoldenFile(String string) {
        this.goldenFile = string;
    }

    public void setExpectHeaders(String string) {
        this.expectHeaders = new Hashtable();
        this.parseHeader(string, this.expectHeaders);
    }

    public void setResponseMatch(String string) {
        this.responseMatch = string;
    }

    public void setRequest(String string) {
        this.request = string;
    }

    public void setReturnCode(String string) {
        this.returnCode = string;
    }

    public void setHeaders(String string) {
        this.requestHeaders = new Hashtable();
        this.parseHeader(string, this.requestHeaders);
    }

    public void execute() throws Exception {
        try {
            this.dispatch(this.request, null);
            boolean bl = this.checkResponse(this.magnitude);
            if (bl) {
                if ("No description".equals(this.description)) {
                    System.out.println("OK " + this.request);
                    return;
                }
                System.out.println("OK " + this.description + " (" + this.request + ")");
                return;
            }
            if ("No description".equals(this.description)) {
                System.out.println("FAIL " + this.request);
                return;
            }
            System.out.println("FAIL " + this.description + " (" + this.request + ")");
            return;
        }
        catch (Exception exception) {
            if ("No description".equals(this.description)) {
                System.out.println("FAIL " + this.request);
            } else {
                System.out.println("FAIL " + this.description + " (" + this.request + ")");
            }
            exception.printStackTrace();
            return;
        }
    }

    private boolean checkResponse(boolean bl) throws Exception {
        boolean bl2 = true;
        if (this.request.indexOf("HTTP/1.") > -1) {
            boolean bl3;
            boolean bl4 = bl3 = this.responseLine != null && this.responseLine.indexOf(this.returnCode) > -1;
            if (bl3 != bl) {
                bl2 = false;
                System.out.println("ERROR in: " + this.request);
                System.out.println("    Expecting: " + this.returnCode);
                System.out.println("    Got      : " + this.responseLine);
            }
        }
        if (this.expectHeaders != null) {
            if (this.headers == null) {
                System.out.println("ERROR no response header, expecting header");
            }
            Enumeration enumeration = this.expectHeaders.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.expectHeaders.get(string);
                String string3 = (String)this.headers.get(string);
                if (string3 != null && string3.indexOf(string2) >= 0) continue;
                System.out.println("ERROR expecting header " + string + ":" + string2 + " GOT: " + string3 + " HEADERS(" + this.headers + ")");
                return false;
            }
        }
        if (this.responseMatch != null) {
            if (this.responseBody == null) {
                System.out.println("ERROR: got no response, expecting " + this.responseMatch);
                return false;
            }
            if (this.responseBody.indexOf(this.responseMatch) < 0) {
                System.out.println("ERROR: expecting match on " + this.responseMatch);
                System.out.println("GOT: ");
                System.out.println(this.responseBody);
            }
        }
        if (this.goldenFile == null) {
            return bl2;
        }
        StringBuffer stringBuffer = this.getExpectedResult();
        boolean bl5 = true;
        bl5 = this.exactMatch ? this.compare(this.responseBody, stringBuffer.toString()) : this.compareWeek(this.responseBody, stringBuffer.toString());
        if (bl5 != bl) {
            bl2 = false;
            System.out.println("ERROR (" + bl5 + "," + bl + ")in : " + this.request);
            System.out.println("====================Expecting: ");
            System.out.println(stringBuffer);
            System.out.println("====================Got:");
            System.out.println(this.responseBody);
            System.out.println("====================");
        }
        return bl2;
    }

    private void dispatch(String string, Hashtable hashtable) throws Exception {
        Socket socket = null;
        socket = new Socket(this.host, this.port);
        InputStream inputStream = socket.getInputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(socket.getOutputStream());
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        try {
            printWriter.println(string);
            if (this.content != null) {
                printWriter.println("Content-Length: " + this.content.length());
            }
            if (string.indexOf("HTTP/1.") > -1) {
                printWriter.println("");
            }
            if (this.content != null) {
                printWriter.println(this.content);
            }
            printWriter.flush();
        }
        catch (Exception exception) {
            System.out.println("Error writing request " + exception);
        }
        try {
            StringBuffer stringBuffer;
            if (string.indexOf("HTTP/1.") > -1) {
                this.responseLine = this.read(inputStream);
                this.headers = this.parseHeaders(inputStream);
            }
            if ((stringBuffer = this.readBody(inputStream)) != null) {
                this.responseBody = stringBuffer.toString();
            }
            if (this.debug > 0) {
                System.out.println("DEBUG Response: ");
                System.out.println(this.responseLine);
                System.out.println(this.responseBody);
                System.out.println("DEBUG END ");
            }
        }
        catch (SocketException socketException) {
            System.out.println("Socket Exception: " + socketException);
            socketException.printStackTrace();
            socket.close();
            return;
        }
        socket.close();
    }

    private StringBuffer getExpectedResult() throws IOException {
        StringBuffer stringBuffer = new StringBuffer("NONE");
        try {
            FileInputStream fileInputStream = new FileInputStream(this.goldenFile);
            return this.readBody(fileInputStream);
        }
        catch (Exception exception) {
            System.out.println("\tGolden file not found: " + this.goldenFile);
            return stringBuffer;
        }
    }

    private boolean compare(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.length() != string2.length()) {
            System.out.println("Wrong size " + string.length() + " " + string2.length());
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != string2.charAt(n)) {
                System.out.println("Error at " + n + " " + string.charAt(1) + string2.charAt(n));
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean compareWeek(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer.nextToken();
            if (string4.equals(string3 = stringTokenizer2.nextToken())) continue;
            System.out.println("\tFAIL*** : Rtok1 = " + string4 + ", Etok2 = " + string3);
            return false;
        }
        return !stringTokenizer.hasMoreTokens() && !stringTokenizer2.hasMoreTokens();
    }

    StringBuffer readBody(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (true) {
                int n;
                if ((n = inputStream.read()) < 0) {
                    if (stringBuffer.length() == 0) {
                        return null;
                    }
                    break;
                }
                stringBuffer.append((char)n);
            }
        }
        catch (IOException iOException) {
            return stringBuffer;
        }
        return stringBuffer;
    }

    private Hashtable parseHeaders(InputStream inputStream) throws IOException {
        String string;
        Hashtable hashtable = new Hashtable();
        while ((string = this.read(inputStream)) != null && string.length() >= 1) {
            this.parseHeader(string, hashtable);
        }
        return hashtable;
    }

    private void parseHeader(String string, Hashtable hashtable) {
        int n = string.indexOf(":");
        if (n < 0) {
            System.out.println("ERROR: Wrong Header Line: " + string);
            return;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        hashtable.put(string2, string3);
    }

    private String read(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        block2: while (true) {
            try {
                while (true) {
                    if ((n = inputStream.read()) < 0) {
                        if (stringBuffer.length() != 0) break block2;
                        if (this.debug > 0) {
                            System.out.println("Error reading line " + n + " " + stringBuffer.toString());
                        }
                        return "";
                    }
                    if (n == 10) break block2;
                    stringBuffer.append((char)n);
                }
            }
            catch (IOException iOException) {
                System.out.println("Error reading : " + iOException);
                this.debug = 1;
                if (this.debug <= 0) continue;
                System.out.println("Partial read: " + stringBuffer.toString());
                continue;
            }
            break;
        }
        if ((n = stringBuffer.length()) > 0 && stringBuffer.charAt(n - 1) == '\r') {
            stringBuffer.setLength(n - 1);
        }
        return stringBuffer.toString();
    }
}

