/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.moo.cookie;

import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.moo.cookie.CookieJarInterface;
import org.apache.tools.moo.cookie.HttpCookie;

public class CookieJar
implements CookieJarInterface {
    private VetoableChangeSupport vceListeners;
    private int listenerNum = 0;
    private static Hashtable cookieJar;
    private static boolean initialized;

    static {
        initialized = false;
    }

    public CookieJar() {
        if (!initialized) {
            this.vceListeners = new VetoableChangeSupport(this);
            cookieJar = new Hashtable();
            initialized = true;
        }
    }

    private void addOrReplaceCookie(Vector vector, HttpCookie httpCookie) {
        int n = vector.size();
        String string = httpCookie.getPath();
        String string2 = httpCookie.getName();
        HttpCookie httpCookie2 = null;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            String string3;
            HttpCookie httpCookie3 = (HttpCookie)vector.elementAt(n3);
            String string4 = httpCookie3.getPath();
            if (string.equals(string4) && string2.equals(string3 = httpCookie3.getName())) {
                httpCookie2 = httpCookie3;
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (httpCookie2 != null) {
            if (httpCookie.isSaveableInMemory()) {
                vector.setElementAt(httpCookie, n2);
            } else {
                vector.removeElementAt(n2);
            }
        } else if (httpCookie.isSaveableInMemory()) {
            vector.addElement(httpCookie);
        }
    }

    public void addToCookieJar(String string, URL uRL) {
        this.recordCookie(new HttpCookie(uRL, string));
    }

    public void addToCookieJar(HttpCookie[] httpCookieArray) {
        if (httpCookieArray != null) {
            int n = 0;
            while (n < httpCookieArray.length) {
                this.recordCookie(httpCookieArray[n]);
                ++n;
            }
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vceListeners.addVetoableChangeListener(vetoableChangeListener);
    }

    private String applyCookiesForHost(URL uRL) {
        String string = null;
        Vector vector = this.getAllRelevantCookies(uRL);
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                HttpCookie httpCookie = (HttpCookie)enumeration.nextElement();
                string = string == null ? httpCookie.getNameValue() : String.valueOf(string) + "; " + httpCookie.getNameValue();
            }
        }
        return string;
    }

    public String applyRelevantCookies(URL uRL) {
        try {
            Properties properties = new Properties();
            InputStream inputStream = this.getClass().getResourceAsStream("cookie.properties");
            properties.load(inputStream);
            String string = properties.getProperty("cookie.acceptpolicy");
            if (string == null || string.equals("none")) {
                return null;
            }
            return this.applyCookiesForHost(uRL);
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception);
            return null;
        }
    }

    public boolean checkIfCookieOK(HttpCookie httpCookie) {
        try {
            if (this.vceListeners != null) {
                this.vceListeners.fireVetoableChange("cookie", null, httpCookie);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            return false;
        }
        return true;
    }

    public void discardAllCookies() {
        try {
            if (this.vceListeners != null) {
                this.vceListeners.fireVetoableChange("cookie", null, null);
            }
        }
        catch (PropertyVetoException propertyVetoException) {}
        cookieJar.clear();
    }

    public HttpCookie[] getAllCookies() {
        HttpCookie[] httpCookieArray;
        Vector<HttpCookie> vector = new Vector<HttpCookie>();
        HttpCookie[] httpCookieArray2 = httpCookieArray = (HttpCookie[])cookieJar.clone();
        synchronized (httpCookieArray2) {
            Enumeration enumeration = httpCookieArray.elements();
            while (enumeration.hasMoreElements()) {
                Vector vector2 = (Vector)enumeration.nextElement();
                int n = 0;
                while (n < vector2.size()) {
                    HttpCookie httpCookie = (HttpCookie)vector2.elementAt(n);
                    vector.addElement(httpCookie);
                    ++n;
                }
            }
        }
        httpCookieArray2 = new HttpCookie[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            httpCookieArray2[n] = (HttpCookie)vector.elementAt(n);
            ++n;
        }
        return httpCookieArray2;
    }

    private Vector getAllRelevantCookies(URL uRL) {
        int n;
        String string = uRL.getHost();
        Vector vector = this.getSubsetRelevantCookies(string, uRL);
        while ((n = string.indexOf(46, 1)) >= 0) {
            Vector vector2 = this.getSubsetRelevantCookies(string = string.substring(n + 1), uRL);
            if (vector2 == null) continue;
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                if (vector == null) {
                    vector = new Vector(2);
                }
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    public HttpCookie[] getCookiesForURL(URL uRL) {
        Vector vector = this.getAllRelevantCookies(uRL);
        if (vector == null) {
            return null;
        }
        int n = 0;
        HttpCookie[] httpCookieArray = new HttpCookie[vector.size()];
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            httpCookieArray[n++] = (HttpCookie)enumeration.nextElement();
        }
        return httpCookieArray;
    }

    private Vector getSubsetRelevantCookies(String string, URL uRL) {
        Object object;
        Object object2;
        Vector vector = (Vector)cookieJar.get(string);
        Vector vector2 = (Vector)cookieJar.get(String.valueOf(string) + ":" + (uRL.getPort() == -1 ? 80 : uRL.getPort()));
        if (vector2 != null) {
            if (vector == null) {
                vector = new Vector(10);
            }
            object2 = vector2.elements();
            while (object2.hasMoreElements()) {
                vector.addElement(object2.nextElement());
            }
        }
        if (vector == null) {
            return null;
        }
        object2 = uRL.getFile();
        int n = ((String)object2).indexOf(63);
        if (n > 0) {
            object2 = ((String)object2).substring(0, n);
        }
        Enumeration enumeration = vector.elements();
        Vector<Object> vector3 = new Vector<Object>(10);
        while (enumeration.hasMoreElements()) {
            HttpCookie httpCookie = (HttpCookie)enumeration.nextElement();
            object = httpCookie.getPath();
            if (!((String)object2).startsWith((String)object) || httpCookie.hasExpired()) continue;
            vector3.addElement(httpCookie);
        }
        if (vector3.size() > 1) {
            int n2 = 0;
            while (n2 < vector3.size() - 1) {
                object = (HttpCookie)vector3.elementAt(n2);
                String string2 = ((HttpCookie)object).getPath();
                if (!string2.endsWith("/")) {
                    string2 = String.valueOf(string2) + "/";
                }
                int n3 = n2 + 1;
                while (n3 < vector3.size()) {
                    HttpCookie httpCookie = (HttpCookie)vector3.elementAt(n3);
                    String string3 = httpCookie.getPath();
                    if (!string3.endsWith("/")) {
                        string3 = String.valueOf(string3) + "/";
                    }
                    int n4 = 0;
                    int n5 = -1;
                    while ((n5 = string2.indexOf(47, n5 + 1)) != -1) {
                        ++n4;
                    }
                    n5 = -1;
                    int n6 = 0;
                    while ((n5 = string3.indexOf(47, n5 + 1)) != -1) {
                        ++n6;
                    }
                    if (n6 > n4) {
                        vector3.setElementAt(object, n3);
                        vector3.setElementAt(httpCookie, n2);
                        object = httpCookie;
                        string2 = string3;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        return vector3;
    }

    public void loadCookieJarFromFile(String string) {
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    HttpCookie httpCookie = new HttpCookie(string2);
                    this.recordCookie(httpCookie);
                }
            }
            finally {
                Object var5_6 = null;
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void purgeExpiredCookies() {
        Enumeration enumeration = cookieJar.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                HttpCookie httpCookie = (HttpCookie)enumeration2.nextElement();
                if (!httpCookie.hasExpired()) continue;
                vector.removeElement(httpCookie);
            }
        }
    }

    public void recordAnyCookies(Vector vector, URL uRL) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        try {
            Properties properties = new Properties();
            InputStream inputStream = this.getClass().getResourceAsStream("cookie.properties");
            properties.load(inputStream);
            String string = properties.getProperty("cookie.acceptpolicy");
            if (string == null || string.equals("none")) {
                return;
            }
            int n = 0;
            while (n < vector.size()) {
                String string2 = (String)vector.elementAt(n);
                this.recordCookie(uRL, string2);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("exception : " + exception);
        }
    }

    public void recordCookie(URL uRL, String string) {
        HttpCookie httpCookie = new HttpCookie(uRL, string);
        String[] stringArray = new String[]{"com", "edu", "net", "org", "gov", "mil", "int"};
        String string2 = httpCookie.getDomain();
        if (string2 == null) {
            return;
        }
        int n = string2.indexOf(58);
        if (n != -1) {
            int n2;
            try {
                n2 = Integer.valueOf(string2.substring(n + 1, string2.length()));
            }
            catch (Exception exception) {
                return;
            }
            n2 = n2 == -1 ? 80 : n2;
            string2 = string2.substring(0, n);
        }
        string2.toLowerCase();
        String string3 = uRL.getHost();
        string3.toLowerCase();
        boolean bl = string3.equals(string2);
        if (!bl && string3.endsWith(string2)) {
            int n3 = 2;
            int n4 = 0;
            while (n4 < stringArray.length) {
                if (string2.endsWith(stringArray[n4])) {
                    n3 = 1;
                }
                ++n4;
            }
            int n5 = string2.length();
            while (n5 > 0 && n3 > 0) {
                n5 = string2.lastIndexOf(46, n5 - 1);
                --n3;
            }
            if (n5 > 0) {
                bl = true;
            }
        }
        if (bl) {
            this.recordCookie(httpCookie);
        }
    }

    public void recordCookie(HttpCookie httpCookie) {
        if (!this.checkIfCookieOK(httpCookie)) {
            return;
        }
        Hashtable hashtable = cookieJar;
        synchronized (hashtable) {
            String string = httpCookie.getDomain().toLowerCase();
            Vector vector = (Vector)cookieJar.get(string);
            if (vector == null) {
                vector = new Vector();
            }
            this.addOrReplaceCookie(vector, httpCookie);
            cookieJar.put(string, vector);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vceListeners.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void saveCookieJarToFile(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            PrintWriter printWriter = new PrintWriter((Writer)fileWriter, false);
            try {
                this.saveCookiesToStream(printWriter);
            }
            finally {
                Object var5_5 = null;
                printWriter.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("Saving cookies failed " + iOException.getMessage());
        }
    }

    private void saveCookiesToStream(PrintWriter printWriter) {
        Enumeration enumeration = cookieJar.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                HttpCookie httpCookie = (HttpCookie)enumeration2.nextElement();
                if (httpCookie.getExpirationDate() == null) continue;
                if (httpCookie.isSaveable()) {
                    printWriter.println(httpCookie);
                    continue;
                }
                vector.removeElement(httpCookie);
            }
        }
        printWriter.print("");
    }

    public void setCookieDisable(boolean bl) {
        try {
            Properties properties = new Properties();
            InputStream inputStream = this.getClass().getResourceAsStream("cookie.properties");
            properties.load(inputStream);
            ((Hashtable)properties).put("enableCookies", bl ? "false" : "true");
            properties.save(new FileOutputStream("ServerAutoRun.properties"), "comments");
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception);
        }
    }

    private boolean shouldRejectCookie(HttpCookie httpCookie) {
        return false;
    }
}

