/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import java.io.Serializable;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Element;
import org.jdom.IllegalAddException;
import org.jdom.PartialList;
import org.jdom.ProcessingInstruction;

public class Document
implements Serializable,
Cloneable {
    protected List content;
    protected Element rootElement;
    protected DocType docType;

    protected Document() {
    }

    public Document(Element element, DocType docType) {
        this.rootElement = element;
        this.docType = docType;
        this.content = new LinkedList();
        if (element != null) {
            element.setDocument(this);
            this.content.add((Object)element);
        }
    }

    public Document(Element element) {
        this(element, null);
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public Document setRootElement(Element element) {
        int n = this.content.size();
        if (this.rootElement != null) {
            this.rootElement.setDocument(null);
            n = this.content.indexOf((Object)this.rootElement);
            this.content.remove(n);
        }
        if (element != null) {
            element.setDocument(this);
            this.content.add(n, (Object)element);
        }
        this.rootElement = element;
        return this;
    }

    public DocType getDocType() {
        return this.docType;
    }

    public Document setDocType(DocType docType) {
        this.docType = docType;
        return this;
    }

    public List getProcessingInstructions() {
        PartialList partialList = new PartialList(this.content);
        Iterator iterator = this.content.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof ProcessingInstruction)) continue;
            partialList.addPartial(object);
        }
        return partialList;
    }

    public List getProcessingInstructions(String string) {
        PartialList partialList = new PartialList(this.content);
        Iterator iterator = this.content.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof ProcessingInstruction) || !((ProcessingInstruction)object).getTarget().equals(string)) continue;
            partialList.addPartial(object);
        }
        return partialList;
    }

    public ProcessingInstruction getProcessingInstruction(String string) {
        Iterator iterator = this.content.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof ProcessingInstruction) || !((ProcessingInstruction)object).getTarget().equals(string)) continue;
            return (ProcessingInstruction)object;
        }
        return null;
    }

    public boolean removeProcessingInstruction(String string) {
        ProcessingInstruction processingInstruction = this.getProcessingInstruction(string);
        if (processingInstruction == null) {
            return false;
        }
        return this.content.remove((Object)processingInstruction);
    }

    public boolean removeProcessingInstructions(String string) {
        boolean bl = false;
        Iterator iterator = this.content.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof ProcessingInstruction) || !((ProcessingInstruction)object).getTarget().equals(string)) continue;
            bl = true;
            iterator.remove();
        }
        return bl;
    }

    public Document setProcessingInstructions(List list) {
        List list2 = this.getProcessingInstructions();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            iterator.remove();
        }
        this.content.addAll((Collection)list);
        return this;
    }

    public Document addContent(ProcessingInstruction processingInstruction) {
        this.content.add((Object)processingInstruction);
        return this;
    }

    public Document addContent(Comment comment) {
        this.content.add((Object)comment);
        return this;
    }

    public Document addContent(Element element) {
        if (this.getRootElement() != null) {
            throw new IllegalAddException(this, element, "The document already has a root element");
        }
        this.setRootElement(element);
        return this;
    }

    public List getMixedContent() {
        return this.content;
    }

    public Document setMixedContent(List list) {
        list.clear();
        this.rootElement = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof Element) {
                this.addContent((Element)object);
                continue;
            }
            if (object instanceof Comment) {
                this.addContent((Comment)object);
                continue;
            }
            if (object instanceof ProcessingInstruction) {
                this.addContent((ProcessingInstruction)object);
                continue;
            }
            throw new IllegalAddException("A Document may contain only objects of type Element, Comment, and ProcessingInstruction");
        }
        return this;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("[Document: ");
        if (this.docType != null) {
            DocType docType = this.docType;
            stringBuffer.append("[DocType: " + docType.getSerializedForm() + "]").append(" ");
        } else {
            stringBuffer.append(" No DOCTYPE declaration. ");
        }
        if (this.rootElement != null) {
            stringBuffer.append("Root - ").append(this.rootElement.toString());
        } else {
            stringBuffer.append(" No Root Element.");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final String getSerializedForm() {
        throw new RuntimeException("Document.getSerializedForm() is not yet implemented");
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final Object clone() {
        Document document = new Document(null);
        Iterator iterator = this.content.iterator();
        while (iterator.hasNext()) {
            Cloneable cloneable;
            Object object = iterator.next();
            if (object instanceof Element) {
                cloneable = (Element)object;
                document.addContent((Element)((Element)cloneable).clone());
                continue;
            }
            if (object instanceof Comment) {
                cloneable = (Comment)object;
                document.addContent((Comment)((Comment)cloneable).clone());
                continue;
            }
            if (!(object instanceof ProcessingInstruction)) continue;
            cloneable = (ProcessingInstruction)object;
            document.addContent((ProcessingInstruction)((ProcessingInstruction)cloneable).clone());
        }
        if (this.docType != null) {
            document.docType = (DocType)this.docType.clone();
        }
        return document;
    }

    public Document addComment(Comment comment) {
        return this.addContent(comment);
    }

    public Document addProcessingInstruction(ProcessingInstruction processingInstruction) {
        return this.addContent(processingInstruction);
    }

    public Document addProcessingInstruction(String string, String string2) {
        return this.addContent(new ProcessingInstruction(string, string2));
    }

    public Document addProcessingInstruction(String string, Map map) {
        return this.addContent(new ProcessingInstruction(string, map));
    }

    public boolean removeProcessingInstruction(ProcessingInstruction processingInstruction) {
        return this.getMixedContent().remove((Object)processingInstruction);
    }
}

