/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import org.jdom.Element;

class PartialList
extends LinkedList {
    protected List backingList;
    protected Element parent;

    public PartialList(List list, Element element) {
        this.backingList = list;
        this.parent = element;
    }

    public PartialList(List list) {
        this(list, null);
    }

    public Object removeFirst() {
        Object object = super.removeFirst();
        this.backingList.remove(object);
        if (object instanceof Element) {
            ((Element)object).setParent(null);
        }
        return object;
    }

    public Object removeLast() {
        Object object = super.removeLast();
        this.backingList.remove(object);
        if (object instanceof Element) {
            ((Element)object).setParent(null);
        }
        return object;
    }

    public void addFirst(Object object) {
        int n = this.backingList.indexOf(this.getFirst());
        super.addFirst(object);
        if (n != -1) {
            this.backingList.add(n, object);
        } else {
            this.backingList.add(object);
        }
        if (object instanceof Element) {
            ((Element)object).setParent(this.parent);
        }
    }

    public void addLast(Object object) {
        int n = this.backingList.indexOf(this.getLast());
        super.addLast(object);
        if (n != -1 && n < this.backingList.size()) {
            this.backingList.add(n + 1, object);
        } else {
            this.backingList.add(object);
        }
        if (object instanceof Element) {
            ((Element)object).setParent(this.parent);
        }
    }

    public boolean add(Object object) {
        this.backingList.add(object);
        if (object instanceof Element) {
            ((Element)object).setParent(this.parent);
        }
        return super.add(object);
    }

    public boolean remove(Object object) {
        this.backingList.remove(object);
        if (object instanceof Element) {
            ((Element)object).setParent(null);
        }
        return super.remove(object);
    }

    public boolean addAll(Collection collection) {
        int n = this.backingList.indexOf(this.getLast());
        if (n != -1) {
            this.backingList.addAll(n, collection);
        } else {
            this.backingList.addAll(collection);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            ((Element)object).setParent(this.parent);
        }
        return super.addAll(collection);
    }

    public boolean addAll(int n, Collection collection) {
        int n2 = this.backingList.indexOf(this.get(n));
        if (n2 != -1) {
            this.backingList.addAll(n2, collection);
        } else {
            this.backingList.addAll(collection);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            ((Element)object).setParent(this.parent);
        }
        return super.addAll(n, collection);
    }

    public void clear() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            this.backingList.remove(object);
            if (!(object instanceof Element)) continue;
            ((Element)object).setParent(null);
        }
        super.clear();
    }

    public Object set(int n, Object object) {
        Object object2 = this.get(n);
        int n2 = this.backingList.indexOf(object2);
        if (n2 != -1) {
            this.backingList.set(n2, object);
        }
        if (object2 instanceof Element) {
            ((Element)object2).setParent(null);
        }
        if (object instanceof Element) {
            ((Element)object).setParent(this.parent);
        }
        return super.set(n, object);
    }

    public void add(int n, Object object) {
        if (n == this.size()) {
            this.addLast(object);
            return;
        }
        this.backingList.add(this.backingList.indexOf(this.get(n)), object);
        if (object instanceof Element) {
            ((Element)object).setParent(this.parent);
        }
        super.add(n, object);
    }

    public Object remove(int n) {
        Object object = super.remove(n);
        this.backingList.remove(object);
        if (object instanceof Element) {
            ((Element)object).setParent(null);
        }
        return object;
    }

    protected void addPartial(Object object) {
        super.add(object);
    }

    protected boolean addAllPartial(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addPartial(iterator.next());
        }
        return true;
    }
}

