/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.Map;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Entity;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.adapters.DOMAdapter;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMBuilder {
    private static final String DEFAULT_ADAPTER_CLASS = "org.jdom.adapters.XercesDOMAdapter";
    private boolean validate;
    private String adapterClass;
    private Map prefixedNamespaces;

    public DOMBuilder(String string, boolean bl) {
        this.adapterClass = string;
        this.validate = bl;
        this.prefixedNamespaces = new HashMap();
        this.prefixedNamespaces.put((Object)"xml", (Object)Namespace.XML_NAMESPACE);
    }

    public DOMBuilder(String string) {
        this(string, false);
    }

    public DOMBuilder(boolean bl) {
        this(DEFAULT_ADAPTER_CLASS, bl);
    }

    public DOMBuilder() {
        this(DEFAULT_ADAPTER_CLASS, false);
    }

    public Document build(InputStream inputStream) throws JDOMException {
        Document document = new Document(null);
        try {
            DOMAdapter dOMAdapter = (DOMAdapter)Class.forName(this.adapterClass).newInstance();
            org.w3c.dom.Document document2 = dOMAdapter.getDocument(inputStream, this.validate);
            this.buildTree(document2, document, null, true);
        }
        catch (Exception exception) {
            throw new JDOMException(exception.getMessage(), exception);
        }
        return document;
    }

    public Document build(File file) throws JDOMException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            return this.build(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JDOMException(fileNotFoundException.getMessage(), fileNotFoundException);
        }
    }

    public Document build(URL uRL) throws JDOMException {
        try {
            return this.build(uRL.openStream());
        }
        catch (IOException iOException) {
            throw new JDOMException(iOException.getMessage(), iOException);
        }
    }

    public Document build(org.w3c.dom.Document document) {
        Document document2 = new Document(null);
        this.buildTree(document, document2, null, true);
        return document2;
    }

    public Element build(org.w3c.dom.Element element) {
        Document document = new Document(null);
        this.buildTree(element, document, null, true);
        return document.getRootElement();
    }

    private void buildTree(Node node, Document document, Element element, boolean bl) {
        switch (node.getNodeType()) {
            case 9: {
                NodeList nodeList = node.getChildNodes();
                int n = 0;
                int n2 = nodeList.getLength();
                while (n < n2) {
                    this.buildTree(nodeList.item(n), document, element, true);
                    ++n;
                }
                return;
            }
            case 1: {
                String string;
                String string2;
                NamedNodeMap namedNodeMap = node.getAttributes();
                LinkedList linkedList = new LinkedList();
                int n = 0;
                int n3 = namedNodeMap.getLength();
                while (n < n3) {
                    Node node2 = namedNodeMap.item(n);
                    if (node2.getNodeName().startsWith("xmlns:")) {
                        string2 = node2.getNodeValue();
                        int n4 = node2.getNodeName().indexOf(":");
                        string = n4 != -1 ? node2.getNodeName().substring(n4 + 1) : "";
                        Namespace namespace = Namespace.getNamespace(string, string2);
                        if (!string.equals("")) {
                            this.prefixedNamespaces.put((Object)string, (Object)namespace);
                        }
                    } else {
                        linkedList.add((Object)node2);
                    }
                    ++n;
                }
                Element element2 = null;
                String string3 = node.getNodeName();
                int n5 = string3.indexOf(":");
                if (n5 != -1) {
                    string = string3.substring(0, n5);
                    string2 = string3.substring(n5 + 1);
                    String string4 = ((Namespace)this.prefixedNamespaces.get((Object)string)).getURI();
                    element2 = new Element(string2, string, string4);
                } else {
                    element2 = new Element(string3);
                }
                if (bl) {
                    document.setRootElement(element2);
                } else {
                    element.addContent(element2);
                }
                int n6 = 0;
                int n7 = linkedList.size();
                while (n6 < n7) {
                    Node node3 = (Node)linkedList.get(n6);
                    if (!node3.getNodeName().startsWith("xmlns:")) {
                        element2.addAttribute(node3.getNodeName(), node3.getNodeValue());
                    }
                    ++n6;
                }
                NodeList nodeList = node.getChildNodes();
                n7 = 0;
                int n8 = nodeList.getLength();
                while (n7 < n8) {
                    this.buildTree(nodeList.item(n7), document, element2, false);
                    ++n7;
                }
                return;
            }
            case 3: {
                String string = node.getNodeValue();
                element.addContent(string);
                return;
            }
            case 4: {
                String string = node.getNodeValue();
                element.addContent(new CDATA(string));
                return;
            }
            case 7: {
                if (bl) {
                    document.addContent(new ProcessingInstruction(node.getNodeName(), node.getNodeValue()));
                    return;
                }
                element.addContent(new ProcessingInstruction(node.getNodeName(), node.getNodeValue()));
                return;
            }
            case 8: {
                if (bl) {
                    document.addContent(new Comment(node.getNodeValue()));
                    return;
                }
                element.addContent(new Comment(node.getNodeValue()));
                return;
            }
            case 5: {
                Entity entity = new Entity(node.getNodeName());
                entity.setContent(node.getFirstChild().getNodeValue());
                element.addContent(entity);
                return;
            }
            case 10: {
                DocumentType documentType = (DocumentType)node;
                String string = documentType.getPublicId();
                String string5 = documentType.getSystemId();
                DocType docType = new DocType(documentType.getName());
                if (string != null && !string.equals("")) {
                    docType.setPublicID(string);
                }
                if (string5 != null && !string5.equals("")) {
                    docType.setSystemID(string5);
                }
                document.setDocType(docType);
                return;
            }
        }
    }
}

