/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Entity;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.adapters.DOMAdapter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMOutputter {
    private static final String DEFAULT_ADAPTER_CLASS = "org.jdom.adapters.XercesDOMAdapter";

    public org.w3c.dom.Document output(Document document) throws JDOMException {
        return this.output(document, DEFAULT_ADAPTER_CLASS);
    }

    public org.w3c.dom.Element output(Element element) throws JDOMException {
        return this.output(element, DEFAULT_ADAPTER_CLASS);
    }

    public Attr output(Attribute attribute) throws JDOMException {
        return this.output(attribute, DEFAULT_ADAPTER_CLASS);
    }

    public org.w3c.dom.Element output(Element element, String string) throws JDOMException {
        LinkedList linkedList = new LinkedList();
        org.w3c.dom.Document document = null;
        try {
            DOMAdapter dOMAdapter = (DOMAdapter)Class.forName(string).newInstance();
            document = dOMAdapter.createDocument();
            this.buildDOMTree(element, document, null, true, linkedList);
        }
        catch (Exception exception) {
            throw new JDOMException("Exception outputting Element " + element.getQualifiedName(), exception);
        }
        return document.getDocumentElement();
    }

    public org.w3c.dom.Document output(Document document, String string) throws JDOMException {
        LinkedList linkedList = new LinkedList();
        org.w3c.dom.Document document2 = null;
        try {
            DOMAdapter dOMAdapter = (DOMAdapter)Class.forName(string).newInstance();
            document2 = dOMAdapter.createDocument();
            List list = document.getMixedContent();
            int n = 0;
            while (n < list.size()) {
                Node node;
                Object object;
                Object object2 = list.get(n);
                if (object2 instanceof Comment) {
                    object = document2.createComment(((Comment)object2).getText());
                    document2.appendChild((Node)object);
                } else if (object2 instanceof ProcessingInstruction) {
                    object = (ProcessingInstruction)object2;
                    node = document2.createProcessingInstruction(((ProcessingInstruction)object).getTarget(), ((ProcessingInstruction)object).getData());
                    document2.appendChild(node);
                } else if (object2 instanceof Element) {
                    this.buildDOMTree(object2, document2, null, true, linkedList);
                } else if (object2 instanceof CDATA) {
                    object = (CDATA)object2;
                    node = document2.createCDATASection(((CDATA)object).getText());
                    document2.appendChild(node);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new JDOMException("Exception outputting Document", exception);
        }
        return document2;
    }

    public Attr output(Attribute attribute, String string) throws JDOMException {
        org.w3c.dom.Document document = null;
        Attr attr = null;
        try {
            DOMAdapter dOMAdapter = (DOMAdapter)Class.forName(string).newInstance();
            document = dOMAdapter.createDocument();
            attr = document.createAttributeNS(attribute.getNamespaceURI(), attribute.getQualifiedName());
            attr.setValue(attribute.getValue());
        }
        catch (Exception exception) {
            throw new JDOMException("Exception outputting Attribute " + attribute.getQualifiedName(), exception);
        }
        return attr;
    }

    protected void buildDOMTree(Object object, org.w3c.dom.Document document, org.w3c.dom.Element element, boolean bl, LinkedList linkedList) {
        boolean bl2 = false;
        if (object instanceof Element) {
            Attribute attribute;
            Object object2;
            Element element2 = (Element)object;
            org.w3c.dom.Element element3 = document.createElement(element2.getQualifiedName());
            Namespace namespace = element2.getNamespace();
            if (namespace != Namespace.NO_NAMESPACE && namespace != Namespace.XML_NAMESPACE && !linkedList.contains((Object)namespace)) {
                object2 = this.getXmlnsTagFor(namespace);
                bl2 = true;
                linkedList.add((Object)namespace);
                element3.setAttribute((String)object2, namespace.getURI());
            }
            object2 = element2.getAttributes();
            int n = 0;
            int n2 = object2.size();
            while (n < n2) {
                attribute = (Attribute)object2.get(n);
                Namespace namespace2 = attribute.getNamespace();
                if (namespace2 != Namespace.NO_NAMESPACE && namespace2 != Namespace.XML_NAMESPACE && !linkedList.contains((Object)namespace2)) {
                    String string = this.getXmlnsTagFor(namespace2);
                    bl2 = true;
                    linkedList.add((Object)namespace2);
                    element3.setAttribute(string, namespace2.getURI());
                }
                element3.setAttribute(attribute.getQualifiedName(), attribute.getValue());
                ++n;
            }
            if (bl) {
                document.appendChild(element3);
            } else {
                element.appendChild(element3);
            }
            attribute = ((Element)object).getMixedContent();
            int n3 = 0;
            while (n3 < attribute.size()) {
                this.buildDOMTree(attribute.get(n3), document, element3, false, linkedList);
                ++n3;
            }
        } else if (object instanceof String) {
            Text text = document.createTextNode((String)object);
            element.appendChild(text);
        } else if (object instanceof ProcessingInstruction) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)object;
            org.w3c.dom.ProcessingInstruction processingInstruction2 = document.createProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
            element.appendChild(processingInstruction2);
        } else if (object instanceof Comment) {
            org.w3c.dom.Comment comment = document.createComment(((Comment)object).getText());
            element.appendChild(comment);
        } else if (object instanceof Entity) {
            EntityReference entityReference = document.createEntityReference(((Entity)object).getName());
            document.appendChild(entityReference);
        } else if (object instanceof CDATA) {
            CDATASection cDATASection = document.createCDATASection(((CDATA)object).getText());
            element.appendChild(cDATASection);
        }
        if (bl2) {
            linkedList.removeLast();
        }
    }

    public String getXmlnsTagFor(Namespace namespace) {
        String string = "xmlns";
        if (!namespace.getPrefix().equals("")) {
            string = String.valueOf(string) + ":";
            string = String.valueOf(string) + namespace.getPrefix();
        }
        return string;
    }
}

