/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;

public class Ant
extends Task {
    private String dir = null;
    private String antFile = null;
    private String target = null;
    private String output = null;
    Vector properties = new Vector();
    Project p1;

    public Property createProperty() {
        Property p = (Property)this.p1.createTask("property");
        p.setUserProperty(true);
        this.properties.addElement(p);
        return p;
    }

    public void execute() throws BuildException {
        if (this.dir == null) {
            this.dir = ".";
        }
        this.p1.setBasedir(this.dir);
        this.p1.setUserProperty("basedir", this.dir);
        Enumeration e = this.properties.elements();
        while (e.hasMoreElements()) {
            Property p = (Property)e.nextElement();
            p.init();
        }
        if (this.antFile == null) {
            this.antFile = String.valueOf(this.dir) + "/build.xml";
        }
        this.p1.setUserProperty("ant.file", this.antFile);
        ProjectHelper.configureProject(this.p1, new File(this.antFile));
        if (this.target == null) {
            this.target = this.p1.getDefaultTarget();
        }
        this.p1.executeTarget(this.target);
    }

    public void init() {
        this.p1 = new Project();
        Vector listeners = this.project.getBuildListeners();
        int i = 0;
        while (i < listeners.size()) {
            this.p1.addBuildListener((BuildListener)listeners.elementAt(i));
            ++i;
        }
        if (this.output != null) {
            try {
                PrintStream out = new PrintStream(new FileOutputStream(this.output));
                this.p1.addBuildListener(new DefaultLogger(out, 2));
            }
            catch (IOException iOException) {
                this.log("Ant: Can't set output to " + this.output);
            }
        }
        this.p1.init();
        Hashtable taskdefs = this.project.getTaskDefinitions();
        Enumeration et = taskdefs.keys();
        while (et.hasMoreElements()) {
            String taskName = (String)et.nextElement();
            Class taskClass = (Class)taskdefs.get(taskName);
            this.p1.addTaskDefinition(taskName, taskClass);
        }
        Hashtable prop1 = this.project.getProperties();
        Enumeration e = prop1.keys();
        while (e.hasMoreElements()) {
            String arg = (String)e.nextElement();
            String value = (String)prop1.get(arg);
            this.p1.setProperty(arg, value);
        }
    }

    public void setAntfile(String s) {
        this.antFile = s;
    }

    public void setDir(String d) {
        this.dir = d;
    }

    public void setOutput(String s) {
        this.output = s;
    }

    public void setTarget(String s) {
        this.target = s;
    }
}

