/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.beans;

import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class JDOMBean {
    private static final String DEFAULT_PARSER = "org.apache.xerces.parsers.SAXParser";
    private String parser;
    private SAXBuilder builder;
    private Map files = new HashMap();
    private File fileRoot;

    public JDOMBean() {
        this.setParser(DEFAULT_PARSER);
    }

    public JDOMBean(String string) {
        this.setParser(string);
    }

    public void setParser(String string) {
        this.parser = string;
        this.builder = new SAXBuilder(string);
    }

    public String getParser() {
        return this.parser;
    }

    public void setFileRoot(String string) {
        if (!string.endsWith("/")) {
            string = String.valueOf(string) + "/";
        }
        this.fileRoot = new File(string);
        System.out.println("fileroot=" + this.fileRoot);
    }

    public String getFileRoot() {
        if (this.fileRoot == null) {
            return null;
        }
        return this.fileRoot.getAbsolutePath();
    }

    public Document getDocument(String string) throws JDOMException {
        File file;
        FileInfo fileInfo = (FileInfo)this.files.get((Object)string);
        File file2 = file = this.fileRoot == null ? new File(string) : new File(this.fileRoot, string);
        if (fileInfo == null || fileInfo.modified < file.lastModified()) {
            Document document = this.builder.build(file);
            fileInfo = new FileInfo(string, file.lastModified(), document);
            this.files.put((Object)string, (Object)fileInfo);
        }
        return fileInfo.document;
    }

    public Element getRootElement(String string) throws JDOMException {
        Document document = this.getDocument(string);
        if (document != null) {
            return document.getRootElement();
        }
        return null;
    }

    private File getFile(String string) {
        if (this.fileRoot == null) {
            return new File(string);
        }
        return new File(this.fileRoot, string);
    }

    public static void main(String[] stringArray) throws IOException, JDOMException {
        JDOMBean jDOMBean;
        int n = 0;
        if (stringArray[n].equals("-parser")) {
            jDOMBean = new JDOMBean(stringArray[++n]);
            ++n;
        } else {
            jDOMBean = new JDOMBean();
        }
        XMLOutputter xMLOutputter = new XMLOutputter();
        while (n < stringArray.length) {
            Document document = jDOMBean.getDocument(stringArray[n]);
            xMLOutputter.output(document, (OutputStream)System.out);
            System.out.println();
            ++n;
        }
    }

    class FileInfo {
        String name;
        long modified;
        Document document;

        public FileInfo(String string, long l, Document document) {
            JDOMBean.this = JDOMBean.this;
            this.name = string;
            this.modified = l;
            this.document = document;
        }
    }
}

