/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.xpath.jdom;

import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.ProcessingInstruction;
import org.jdom.contrib.xpath.NodeSet;
import org.jdom.contrib.xpath.XPathElement;
import org.jdom.contrib.xpath.XPathParseException;
import org.jdom.contrib.xpath.impl.Step;

public class JdomNodeSet
extends NodeSet {
    private XPathElement reusableXPathElement;

    public JdomNodeSet(Element element) {
        this.add(element);
    }

    public JdomNodeSet(Attribute attribute) {
        this.add(attribute);
    }

    public void add(Element element) {
        super.add(element);
    }

    public void add(Attribute attribute) {
        super.add(attribute);
    }

    public void add(ProcessingInstruction processingInstruction) {
        super.add(processingInstruction);
    }

    public void add(Comment comment) {
        super.add(comment);
    }

    public void add(String string) {
        super.add(string);
    }

    public void applyAbsolute() {
        Element element = this.getFirstElementInSet();
        this.list().clear();
        if (element != null) {
            element = this.elemext(element).getRootElement();
            this.add(element);
        }
    }

    protected void nodetestAttribute(Object object, Step step, List list) throws XPathParseException {
        if (!(object instanceof Element)) {
            return;
        }
        Element element = (Element)object;
        switch (step.getNodetype().getCode()) {
            case 5: {
                if ("*".equals(step.getLocalName())) {
                    list.addAll((Collection)element.getAttributes());
                    return;
                }
                Attribute attribute = this.elemext(element).getAttribute(step.getPrefix(), step.getLocalName());
                if (attribute == null) break;
                list.add((Object)attribute);
                return;
            }
            default: {
                throw new XPathParseException("Cannot have axis=ATTRIBUTE for any other than nodetype=ELEMENT.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void nodetestChild(Object object, Step step, List list) throws XPathParseException {
        if (!(object instanceof Element)) {
            return;
        }
        Element element = (Element)object;
        switch (step.getNodetype().getCode()) {
            case 1: {
                if (step.getLocalName() != null) throw new XPathParseException("LocalName for nodes is meaningless.  (localName=" + step.getLocalName() + ")");
                if (step.isAbsolute()) {
                    list.add((Object)element);
                    return;
                }
                list.addAll((Collection)element.getMixedContent());
                return;
            }
            case 5: {
                if (step.isAbsolute()) {
                    String string = element.getNamespacePrefix();
                    String string2 = step.getPrefix();
                    if (string == null) {
                        if (string2 != null) {
                            return;
                        }
                    } else {
                        boolean bl = string.equals(string2);
                        if (!bl) return;
                    }
                    string = element.getName();
                    string2 = step.getLocalName();
                    if (string == null) {
                        if (string2 != null) {
                            return;
                        }
                    } else {
                        boolean bl = string.equals(string2);
                        if (!bl) return;
                    }
                    list.add((Object)element);
                    return;
                }
                list.addAll((Collection)this.elemext(element).getChildren(step.getPrefix(), step.getLocalName()));
                return;
            }
            case 2: {
                if (step.getLocalName() != null) throw new XPathParseException("LocalName for comments is meaningless.  (localName=" + step.getLocalName() + ")");
                if (step.isAbsolute()) return;
                list.addAll((Collection)this.elemext(element).getComments());
                return;
            }
            case 3: {
                if (step.getLocalName() != null) throw new XPathParseException("LocalName for text is meaningless.  (localName=" + step.getLocalName() + ")");
                if (step.isAbsolute()) return;
                list.addAll((Collection)this.elemext(element).getTextChildren());
                return;
            }
            case 4: {
                if (step.getLocalName() == null) {
                    if (step.isAbsolute()) return;
                    list.addAll((Collection)this.elemext(element).getProcessingInstructions());
                    return;
                }
                if (step.isAbsolute()) return;
                list.addAll((Collection)this.elemext(element).getProcessingInstructions(step.getLocalName()));
                return;
            }
        }
    }

    private XPathElement elemext(Element element) {
        if (this.reusableXPathElement == null) {
            this.reusableXPathElement = new XPathElement(element);
        } else {
            this.reusableXPathElement.extend(element);
        }
        return this.reusableXPathElement;
    }

    private Element getFirstElementInSet() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            return (Element)object;
        }
        return null;
    }
}

