/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.xpath.a;

import java.util.StringTokenizer;
import org.jdom.contrib.xpath.XPathParseException;
import org.jdom.contrib.xpath.a.ParseUtils;
import org.jdom.contrib.xpath.a.PoCPredicateParser;
import org.jdom.contrib.xpath.a.XPathHandler;
import org.jdom.contrib.xpath.a.XPathParser;
import org.jdom.contrib.xpath.a.XPathPredicateHandler;
import org.jdom.contrib.xpath.a.XPathPredicateParser;

public class PoCParser
implements XPathParser {
    private XPathHandler handler;
    private XPathPredicateParser predicateParser;

    protected void assertValidCharacters(String xpath) throws XPathParseException {
        if (xpath == null) {
            throw new XPathParseException("xpath cannot be null");
        }
        if ("".equals(xpath = xpath.trim())) {
            throw new XPathParseException("xpath cannot be empty");
        }
    }

    public XPathHandler getXPathHandler() {
        return this.handler;
    }

    public XPathPredicateParser getXPathPredicateParser() {
        return this.predicateParser;
    }

    public void parse(String xpath) throws XPathParseException {
        if (this.handler == null) {
            throw new XPathParseException("Must set a XPathHandler first.  See XPathParser.setXPathHandler(XPathHandler).");
        }
        try {
            this.handler.startParsingXPath();
            this.assertValidCharacters(xpath);
            this.parseWhole(xpath);
        }
        finally {
            Object var3_2 = null;
            this.handler.endParsingXPath();
        }
    }

    private void parseLocationPath(String xpath) throws XPathParseException {
        this.handler.startPath();
        xpath = xpath.trim();
        if (xpath.charAt(0) == '/') {
            this.handler.absolute();
            xpath = xpath.substring(1);
        }
        int i = xpath.indexOf(47);
        while (i != -1) {
            if (i == 0) {
                this.parseStep(null);
            } else {
                this.parseStep(xpath.substring(0, i));
            }
            xpath = xpath.substring(i + 1);
            i = xpath.indexOf(47);
        }
        this.parseStep(xpath);
        this.handler.endPath();
    }

    private void parseNodeTest(String nodetest) throws XPathParseException {
        int indexOpenParen;
        int indexAxis = nodetest.indexOf("::");
        String axis = null;
        if (indexAxis != -1) {
            axis = nodetest.substring(0, indexAxis);
            nodetest = nodetest.substring(indexAxis + 2, nodetest.length());
        }
        if ((indexOpenParen = nodetest.indexOf(40)) == -1) {
            int indexColon = nodetest.indexOf(58);
            if (indexColon == -1) {
                this.handler.nametest(axis, null, nodetest);
            } else {
                this.handler.nametest(axis, nodetest.substring(0, indexColon), nodetest.substring(indexColon + 1));
            }
        } else {
            int indexCloseParen = nodetest.indexOf(41);
            if (indexCloseParen == -1) {
                throw new XPathParseException("Closing parenthesis expected: " + nodetest);
            }
            if (indexCloseParen < indexOpenParen) {
                throw new XPathParseException("Closing parenthesis found before opening: " + nodetest);
            }
            this.handler.nodetype(axis, nodetest.substring(0, indexOpenParen), ParseUtils.extractLiteral(nodetest.substring(indexOpenParen + 1, indexCloseParen)));
        }
    }

    private void parsePredicate(String predicate) throws XPathParseException {
        XPathPredicateHandler predicateHandler = this.handler.startXPathPredicate();
        if (this.predicateParser == null) {
            this.predicateParser = new PoCPredicateParser();
        }
        if (this.predicateParser.getXPathParser() == null) {
            this.predicateParser.setXPathParser(this);
        }
        this.predicateParser.setXPathPredicateHandler(predicateHandler);
        this.predicateParser.parsePredicate(predicate);
        this.handler.endXPathPredicate(predicateHandler);
    }

    private void parsePredicates(String string) throws XPathParseException {
        int i = string.indexOf(91);
        while (i != -1) {
            int indexEnd = string.indexOf(93);
            this.parsePredicate(string.substring(i + 1, indexEnd));
            string = string.substring(indexEnd + 1);
            i = string.indexOf(91);
        }
    }

    private void parseStep(String xstep) throws XPathParseException {
        this.handler.startStep();
        if (xstep != null) {
            int indexPredicate = (xstep = xstep.trim()).indexOf(91);
            if (indexPredicate == -1) {
                this.parseNodeTest(xstep);
            } else {
                this.parseNodeTest(xstep.substring(0, indexPredicate));
                this.parsePredicates(xstep.substring(indexPredicate));
            }
        }
        this.handler.endStep();
    }

    private void parseWhole(String xpath) throws XPathParseException {
        if (xpath.indexOf(124) == -1) {
            this.parseLocationPath(xpath);
        } else {
            StringTokenizer st = new StringTokenizer(xpath, "|");
            while (st.hasMoreTokens()) {
                this.parseLocationPath(st.nextToken());
            }
        }
    }

    public void setXPathHandler(XPathHandler handler) {
        this.handler = handler;
    }

    public void setXPathPredicateParser(XPathPredicateParser parser) {
        this.predicateParser = parser;
    }
}

