/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.xpath.jdom;

import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.ProcessingInstruction;
import org.jdom.contrib.xpath.NodeSet;
import org.jdom.contrib.xpath.XPathElement;
import org.jdom.contrib.xpath.XPathParseException;
import org.jdom.contrib.xpath.impl.Step;

public class JdomNodeSet
extends NodeSet {
    private XPathElement reusableXPathElement;

    public JdomNodeSet(Attribute attribute) {
        this.add(attribute);
    }

    public JdomNodeSet(Element element) {
        this.add(element);
    }

    public void add(String text) {
        super.add(text);
    }

    public void add(Attribute attribute) {
        super.add(attribute);
    }

    public void add(Comment comment) {
        super.add(comment);
    }

    public void add(Element element) {
        super.add(element);
    }

    public void add(ProcessingInstruction pi) {
        super.add(pi);
    }

    public void applyAbsolute() {
        Element elem = this.getFirstElementInSet();
        this.list().clear();
        if (elem != null) {
            elem = this.elemext(elem).getRootElement();
            this.add(elem);
        }
    }

    private XPathElement elemext(Element element) {
        if (this.reusableXPathElement == null) {
            this.reusableXPathElement = new XPathElement(element);
        } else {
            this.reusableXPathElement.extend(element);
        }
        return this.reusableXPathElement;
    }

    private Element getFirstElementInSet() {
        Element result = null;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof Element)) continue;
            return (Element)each;
        }
        return result;
    }

    protected void nodetestAttribute(Object context, Step step, List list) throws XPathParseException {
        if (!(context instanceof Element)) {
            return;
        }
        Element element = (Element)context;
        switch (step.getNodetype().getCode()) {
            case 5: {
                if ("*".equals(step.getLocalName())) {
                    list.addAll(element.getAttributes());
                    break;
                }
                Attribute attr = this.elemext(element).getAttribute(step.getPrefix(), step.getLocalName());
                if (attr == null) break;
                list.add(attr);
                break;
            }
            default: {
                throw new XPathParseException("Cannot have axis=ATTRIBUTE for any other than nodetype=ELEMENT.");
            }
        }
    }

    protected void nodetestChild(Object context, Step step, List list) throws XPathParseException {
        if (!(context instanceof Element)) {
            return;
        }
        Element element = (Element)context;
        switch (step.getNodetype().getCode()) {
            case 1: {
                if (step.getLocalName() == null) {
                    if (step.isAbsolute()) {
                        list.add(element);
                        break;
                    }
                    list.addAll(element.getMixedContent());
                    break;
                }
                throw new XPathParseException("LocalName for nodes is meaningless.  (localName=" + step.getLocalName() + ")");
            }
            case 5: {
                if (step.isAbsolute()) {
                    if (!NodeSet.equals(element.getNamespacePrefix(), step.getPrefix()) || !NodeSet.equals(element.getName(), step.getLocalName())) break;
                    list.add(element);
                    break;
                }
                list.addAll(this.elemext(element).getChildren(step.getPrefix(), step.getLocalName()));
                break;
            }
            case 2: {
                if (step.getLocalName() == null) {
                    if (step.isAbsolute()) break;
                    list.addAll(this.elemext(element).getComments());
                    break;
                }
                throw new XPathParseException("LocalName for comments is meaningless.  (localName=" + step.getLocalName() + ")");
            }
            case 3: {
                if (step.getLocalName() == null) {
                    if (step.isAbsolute()) break;
                    list.addAll(this.elemext(element).getTextChildren());
                    break;
                }
                throw new XPathParseException("LocalName for text is meaningless.  (localName=" + step.getLocalName() + ")");
            }
            case 4: {
                if (step.getLocalName() == null) {
                    if (step.isAbsolute()) break;
                    list.addAll(this.elemext(element).getProcessingInstructions());
                    break;
                }
                if (step.isAbsolute()) break;
                list.addAll(this.elemext(element).getProcessingInstructions(step.getLocalName()));
                break;
            }
        }
    }
}

