/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.Tokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public final class Utils {
    private static final void addPIPseudoAttributes(ProcessingInstruction pi, Hashtable attributes) {
        String data = pi.getData();
        Tokenizer st = new Tokenizer(data, "\"");
        try {
            while (st.hasMoreTokens()) {
                String key = st.nextToken();
                String token = st.nextToken();
                key = key.replace('=', ' ').trim();
                attributes.put(key, token);
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    public static final String encode(HttpServletRequest req) {
        return Utils.encode(req, true, true);
    }

    public static final String encode(HttpServletRequest req, boolean agent) {
        return Utils.encode(req, agent, true);
    }

    public static final String encode(HttpServletRequest req, boolean agent, boolean query) {
        StringBuffer url = new StringBuffer();
        if (agent) {
            url.append(req.getHeader("user-Agent"));
            url.append(':');
        }
        url.append(req.getScheme());
        url.append("://");
        url.append(req.getServerName());
        url.append(':');
        url.append(req.getServerPort());
        url.append(req.getRequestURI());
        if (query) {
            url.append('?');
            url.append(req.getQueryString());
        }
        return url.toString();
    }

    public static final Vector getAllPIs(Document document, String name) {
        return Utils.getAllPIs(document, name, false);
    }

    public static final Vector getAllPIs(Document document, String name, boolean remove) {
        Vector<Node> pis = new Vector<Node>();
        NodeList nodelist = document.getChildNodes();
        int i = nodelist.getLength();
        int j = 0;
        while (j < i) {
            Node node = nodelist.item(j);
            if (node.getNodeType() == 7 && ((ProcessingInstruction)node).getTarget().equals(name)) {
                pis.addElement(node);
                if (remove) {
                    node.getParentNode().removeChild(node);
                    --i;
                }
            }
            ++j;
        }
        return pis;
    }

    public static final String getBasename(HttpServletRequest request, Object context) {
        try {
            String resource;
            request.getContextPath();
            String path = (String)request.getAttribute("javax.servlet.include.servlet_path");
            if (path == null) {
                path = request.getServletPath();
            }
            if ((resource = ((ServletContext)context).getRealPath(path)) != null) {
                return resource.replace('\\', '/');
            }
            throw new RuntimeException("Cannot access non-file/war resources");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            String path = request.getPathInfo() != null ? request.getPathTranslated() : request.getRealPath(request.getRequestURI());
            return path == null ? "" : path.replace('\\', '/');
        }
        catch (NullPointerException nullPointerException) {
            return request.getPathTranslated().replace('\\', '/');
        }
    }

    public static final String getBasepath(HttpServletRequest request, Object context) {
        String basename = Utils.getBasename(request, context);
        return basename.substring(0, basename.lastIndexOf(47) + 1);
    }

    public static final ProcessingInstruction getFirstPI(Document document, String name) {
        return Utils.getFirstPI(document, name, false);
    }

    public static final ProcessingInstruction getFirstPI(Document document, String name, boolean remove) {
        ProcessingInstruction pi = null;
        NodeList nodelist = document.getChildNodes();
        int i = nodelist.getLength();
        int j = 0;
        while (j < i) {
            Node node = nodelist.item(j);
            if (node.getNodeType() == 7 && ((ProcessingInstruction)node).getTarget().equals(name)) {
                pi = (ProcessingInstruction)node;
                if (!remove) break;
                node.getParentNode().removeChild(node);
                break;
            }
            ++j;
        }
        return pi;
    }

    public static final Object getLocationResource(String location) throws MalformedURLException {
        Serializable resource = null;
        resource = location.indexOf("://") < 0 ? new File(location) : (location.startsWith("resource://") ? ClassLoader.getSystemResource(location.substring("resource://".length())) : new URL(location));
        return resource;
    }

    public static final Object getLocationResource(String location, HttpServletRequest request, ServletContext context) throws Exception {
        Serializable resource = null;
        if (location.indexOf("://") < 0) {
            if (location.charAt(0) == '/') {
                location = request.getRealPath(location);
            } else {
                String basename = Utils.getBasename(request, context);
                location = String.valueOf(basename.substring(0, basename.lastIndexOf(47) + 1)) + location;
            }
            resource = new File(location);
        } else {
            resource = location.startsWith("resource://") ? ClassLoader.getSystemResource(location.substring("resource://".length())) : new URL(location);
        }
        return resource;
    }

    public static final Hashtable getPIPseudoAttributes(Document document, String name) {
        Hashtable attributes = new Hashtable();
        Enumeration nodes = Utils.getAllPIs(document, name).elements();
        while (nodes.hasMoreElements()) {
            ProcessingInstruction pi = (ProcessingInstruction)nodes.nextElement();
            Utils.addPIPseudoAttributes(pi, attributes);
        }
        return attributes;
    }

    public static final Hashtable getPIPseudoAttributes(ProcessingInstruction pi) {
        Hashtable attributes = new Hashtable();
        Utils.addPIPseudoAttributes(pi, attributes);
        return attributes;
    }

    public static final String getRootpath(HttpServletRequest request, Object context) {
        return request.getRealPath("/");
    }

    public static final String getStackTraceAsString(Throwable e) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(bytes, true);
        e.printStackTrace(writer);
        return bytes.toString();
    }
}

