/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.interpreter.ecmascript;

import FESI.jslib.JSException;
import FESI.jslib.JSGlobalObject;
import java.util.Dictionary;
import org.apache.cocoon.interpreter.Instance;
import org.apache.cocoon.interpreter.LanguageException;
import org.apache.cocoon.interpreter.ecmascript.EcmaScriptEvaluator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EcmaScriptInstance
implements Instance {
    private Document document;
    private EcmaScriptEvaluator evaluator;

    public EcmaScriptInstance(EcmaScriptEvaluator theEvaluator, Document theDocument) throws LanguageException {
        this.evaluator = theEvaluator;
        this.document = theDocument;
    }

    public void destroy() {
        this.evaluator.release();
    }

    public Object getInstance() {
        return this.evaluator.getGlobalObject();
    }

    public Node invoke(String methodName, Dictionary parameters, Node source) throws LanguageException {
        try {
            Object[] functionArgs = new Object[]{parameters, source};
            JSGlobalObject globalObject = this.evaluator.getGlobalObject();
            Object object = globalObject.call(methodName, functionArgs);
            if (object == null) {
                return null;
            }
            if (object instanceof Node) {
                return (Node)object;
            }
            return this.document.createTextNode(object.toString());
        }
        catch (JSException e) {
            e.printStackTrace();
            throw new LanguageException(e.getMessage());
        }
    }
}

