/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.dcp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.apache.cocoon.Tokenizer;
import org.apache.cocoon.framework.Director;
import org.apache.cocoon.interpreter.Instance;
import org.apache.cocoon.interpreter.Interpreter;
import org.apache.cocoon.interpreter.InterpreterFactory;
import org.apache.cocoon.interpreter.Module;
import org.apache.cocoon.processor.dcp.DCPException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DCPEngine {
    private static final String OBJECT_PI = "dcp-object";
    private static final String CONTENT_PI = "dcp-content";
    private static final String VARIABLE_PI = "dcp-var";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String LANGUAGE_ATTRIBUTE = "language";
    private static final String CODE_ATTRIBUTE = "code";
    private static final String METHOD_ATTRIBUTE = "method";
    private InterpreterFactory interpreterFactory;
    private Document document;
    private Director director;
    private Dictionary parameters;
    private Hashtable instances;
    private Hashtable globalVariables;

    public DCPEngine(Document document, InterpreterFactory factory, Dictionary parameters) {
        this.document = document;
        this.interpreterFactory = factory;
        this.parameters = parameters;
        this.instances = new Hashtable(10);
        this.globalVariables = new Hashtable(10);
    }

    private void doProcess(Node node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 1: 
            case 9: {
                Node[] children = this.getChildren(node);
                int i = 0;
                while (i < children.length) {
                    this.doProcess(children[i]);
                    ++i;
                }
                break;
            }
            case 7: {
                Node parent = node.getParentNode();
                ProcessingInstruction pi = (ProcessingInstruction)node;
                try {
                    String target = pi.getTarget();
                    if (target.equals(OBJECT_PI)) {
                        this.processObject(pi);
                        parent.removeChild(pi);
                        break;
                    }
                    if (target.equals(CONTENT_PI)) {
                        Node result = this.processContent(pi);
                        if (result == null) {
                            parent.removeChild(pi);
                            break;
                        }
                        parent.replaceChild(result, pi);
                        break;
                    }
                    if (!target.equals(VARIABLE_PI)) break;
                    this.processVariable(pi);
                    parent.removeChild(pi);
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    String className = e.getClass().getName();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter((Writer)sw, true);
                    e.printStackTrace(pw);
                    Text errorText = this.document.createTextNode("{DCP Error: " + className + ": " + message + "}\n" + sw.toString());
                    parent.replaceChild(errorText, pi);
                }
                break;
            }
        }
    }

    private Node[] getChildren(Node node) {
        NodeList nodeList = node.getChildNodes();
        int childCount = nodeList.getLength();
        Node[] children = new Node[childCount];
        int i = 0;
        while (i < childCount) {
            children[i] = nodeList.item(i);
            ++i;
        }
        return children;
    }

    /*
     * Unable to fully structure code
     */
    private void parseAttributes(String data, Hashtable attributes) {
        length = data.length();
        chars = data.toCharArray();
        try {
            index = 0;
            ** GOTO lbl35
            {
                ++index;
                do {
                    if (index < length && chars[index] <= ' ') continue block2;
                    nameBuffer = new StringBuffer();
                    while (index < length && chars[index] != '=' && chars[index] > ' ') {
                        nameBuffer.append(chars[index++]);
                    }
                    name = nameBuffer.toString();
                    while (index < length && chars[index] <= ' ') {
                        ++index;
                    }
                    if (chars[index++] == '=') ** GOTO lbl21
                    throw new Exception("Invalid attribute name: '" + name + "'");
lbl-1000:
                    // 1 sources

                    {
                        ++index;
lbl21:
                        // 2 sources

                        ** while (index < length && chars[index] <= ' ')
                    }
lbl22:
                    // 1 sources

                    if (chars[index++] != '\"') {
                        throw new Exception("Invalid attribute value for '" + name + "'");
                    }
                    valueBuffer = new StringBuffer();
                    while (index < length && chars[index] != '\"') {
                        valueBuffer.append(chars[index++]);
                    }
                    value = valueBuffer.toString();
                    if (index == length || chars[index] != '\"') {
                        throw new Exception("Unterminated string '" + value + "' in attribute '" + name + "'");
                    }
                    attributes.put(name, value);
                    ++index;
lbl35:
                    // 2 sources

                } while (index < length);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public void process() throws Exception {
        this.doProcess(this.document);
        Enumeration e = this.instances.keys();
        while (e.hasMoreElements()) {
            String instanceName = (String)e.nextElement();
            Instance instance = (Instance)this.instances.get(instanceName);
            instance.destroy();
        }
    }

    private Node processContent(ProcessingInstruction pi) throws Exception {
        Hashtable attributes = (Hashtable)this.globalVariables.clone();
        this.parseAttributes(pi.getData(), attributes);
        String methodReference = (String)attributes.get(METHOD_ATTRIBUTE);
        if (methodReference == null) {
            throw new DCPException("Missing method name in content generation");
        }
        String objectName = null;
        String methodName = null;
        Tokenizer st = new Tokenizer(methodReference, ".");
        try {
            objectName = st.nextToken();
            methodName = st.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DCPException("Invalid method reference: " + methodReference);
        }
        Instance instance = (Instance)this.instances.get(objectName);
        if (instance == null) {
            throw new DCPException("Undefined object: " + objectName);
        }
        return instance.invoke(methodName, attributes, pi);
    }

    private void processObject(ProcessingInstruction pi) throws Exception {
        Hashtable attributes = new Hashtable();
        this.parseAttributes(pi.getData(), attributes);
        String objectName = (String)attributes.get(NAME_ATTRIBUTE);
        if (objectName == null) {
            throw new DCPException("Missing name in object definition");
        }
        if (this.instances.containsKey(objectName)) {
            throw new DCPException("Duplicate object name: " + objectName);
        }
        String codeLocation = (String)attributes.get(CODE_ATTRIBUTE);
        if (codeLocation == null) {
            throw new DCPException("Missing code location in object definition");
        }
        String languageName = (String)attributes.get(LANGUAGE_ATTRIBUTE);
        Interpreter interpreter = this.interpreterFactory.getInterpreter(languageName);
        Module module = interpreter.createModule(codeLocation);
        Instance instance = module.createInstance(this.document, this.parameters);
        this.instances.put(objectName, instance);
    }

    private void processVariable(ProcessingInstruction pi) throws Exception {
        this.parseAttributes(pi.getData(), this.globalVariables);
    }
}

