/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xinclude;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.Utils;
import org.apache.cocoon.framework.AbstractActor;
import org.apache.cocoon.framework.Director;
import org.apache.cocoon.framework.Monitor;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.logger.Logger;
import org.apache.cocoon.parser.Parser;
import org.apache.cocoon.processor.Processor;
import org.apache.cocoon.xml.util.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XIncludeProcessor
extends AbstractActor
implements Processor,
Status {
    protected boolean debug = true;
    public static final String XMLBASE_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLBASE_ATTRIBUTE = "base";
    public static final String XINCLUDE_NAMESPACE_URI = "http://www.w3.org/1999/XML/xinclude";
    public static final String XINCLUDE_INCLUDE_ELEMENT = "include";
    public static final String XINCLUDE_INCLUDE_ELEMENT_HREF_ATTRIBUTE = "href";
    public static final String XINCLUDE_INCLUDE_ELEMENT_PARSE_ATTRIBUTE = "parse";
    protected Parser parser;
    protected Logger logger;
    protected Object context;
    protected Monitor monitor;
    protected Hashtable monitored_table;

    public String getStatus() {
        return "XInclude Processor";
    }

    public boolean hasChanged(Object object) {
        String key = Utils.encode((HttpServletRequest)object);
        if (this.monitored_table.containsKey(key)) {
            return this.monitor.hasChanged(key);
        }
        return false;
    }

    public void init(Director director) {
        super.init(director);
        this.parser = (Parser)director.getActor("parser");
        this.logger = (Logger)director.getActor("logger");
        this.context = director.getActor("context");
        this.monitor = new Monitor(10);
        this.monitored_table = new Hashtable();
    }

    public Document process(Document document, Dictionary parameters) throws Exception {
        XIncludeProcessorWorker worker = new XIncludeProcessorWorker(this, document, parameters);
        worker.process();
        return worker.document;
    }

    class XIncludeProcessorWorker {
        boolean debug;
        XIncludeProcessor processor;
        Document document;
        File base_file = null;
        URL current_xmlbase_uri = null;
        Stack xmlbase_stack = new Stack();
        Hashtable namespace_table = new Hashtable();
        Object monitor_key;

        XIncludeProcessorWorker(XIncludeProcessor processor, Document document, Dictionary parameters) throws Exception {
            this.processor = processor;
            this.debug = processor.debug;
            this.document = document;
            HttpServletRequest request = (HttpServletRequest)parameters.get("request");
            this.monitor_key = Utils.encode(request);
            String basename = Utils.getBasename(request, XIncludeProcessor.this.context);
            if (this.debug) {
                System.err.println("basename: " + basename);
            }
            this.base_file = new File(new File(basename).getParent());
        }

        void endXMLBaseAttribute() {
            this.current_xmlbase_uri = (URL)this.xmlbase_stack.pop();
        }

        void process() throws Exception {
            Element element = this.document.getDocumentElement();
            NamedNodeMap attributes = element.getAttributes();
            int length = attributes.getLength();
            int i = 0;
            while (i < length) {
                Attr attr = (Attr)attributes.item(i);
                String name = attr.getName();
                if (name.length() >= 6 && name.substring(0, 6).equals("xmlns:")) {
                    String prefix = name.substring(6);
                    String uri = attr.getValue();
                    this.namespace_table.put(prefix, uri);
                }
                ++i;
            }
            this.process(element);
        }

        void process(Element element) throws Exception {
            String name = element.getTagName();
            String uri = "";
            int index = name.indexOf(58);
            if (index >= 0) {
                String prefix = name.substring(0, index);
                name = name.substring(index + 1);
                uri = (String)this.namespace_table.get(prefix);
            }
            if (this.debug) {
                System.err.println("Processing element: " + element);
                System.err.println("Name: " + name);
                System.err.println("URI: " + uri);
            }
            boolean xmlbase_attribute = false;
            String value = element.getAttributeNS(XIncludeProcessor.XMLBASE_NAMESPACE_URI, XIncludeProcessor.XMLBASE_ATTRIBUTE);
            if (value != null) {
                this.startXMLBaseAttribute(value);
                xmlbase_attribute = true;
            }
            if (uri != null && uri.equals(XIncludeProcessor.XINCLUDE_NAMESPACE_URI) && name.equals(XIncludeProcessor.XINCLUDE_INCLUDE_ELEMENT)) {
                String href = element.getAttribute(XIncludeProcessor.XINCLUDE_INCLUDE_ELEMENT_HREF_ATTRIBUTE);
                String parse = element.getAttribute(XIncludeProcessor.XINCLUDE_INCLUDE_ELEMENT_PARSE_ATTRIBUTE);
                this.processXIncludeElement(element, href, parse);
            }
            NodeList child_nodes = element.getElementsByTagName("*");
            int length = child_nodes.getLength();
            Element[] ary = new Element[length];
            int i = 0;
            while (i < length) {
                ary[i] = (Element)child_nodes.item(i);
                ++i;
            }
            int i2 = 0;
            while (i2 < length) {
                this.process(ary[i2]);
                ++i2;
            }
            if (xmlbase_attribute) {
                this.endXMLBaseAttribute();
            }
        }

        void processXIncludeElement(Element element, String href, String parse) throws Exception {
            Object input;
            Object object;
            String suffix;
            int index;
            if (this.debug) {
                System.err.println("Processing XInclude element: href=" + href + ", parse=" + parse);
            }
            if ((index = href.indexOf(35)) < 0) {
                suffix = "";
            } else {
                suffix = href.substring(index + 1);
                if (this.debug) {
                    System.err.println("Suffix: " + suffix);
                }
                href = href.substring(0, index);
            }
            if (this.current_xmlbase_uri != null) {
                URL url = new URL(this.current_xmlbase_uri, href);
                this.processor.monitored_table.put(this.monitor_key, "");
                this.processor.monitor.watch(this.monitor_key, url);
                if (this.debug) {
                    System.err.println("URL: " + url);
                }
                object = url.getContent();
            } else {
                File file = new File(this.base_file, href);
                this.processor.monitored_table.put(this.monitor_key, "");
                this.processor.monitor.watch(this.monitor_key, file);
                if (this.debug) {
                    System.err.println("File: " + file);
                }
                object = new FileReader(file);
            }
            if (this.debug) {
                System.err.println("Object: " + object);
            }
            DocumentFragment result_fragment = this.document.createDocumentFragment();
            if (parse.equals("text")) {
                if (this.debug) {
                    System.err.println("Parse type is text");
                }
                if (object instanceof Reader) {
                    Reader reader = (Reader)object;
                    char[] ary = new char[1024];
                    StringBuffer sb = new StringBuffer();
                    if (reader != null) {
                        int read;
                        while ((read = reader.read(ary)) != -1) {
                            sb.append(ary, 0, read);
                        }
                        reader.close();
                    }
                    result_fragment.appendChild(this.document.createTextNode(sb.toString()));
                } else if (object instanceof InputStream) {
                    input = (InputStream)object;
                    InputStreamReader reader = new InputStreamReader((InputStream)input);
                    char[] ary = new char[1024];
                    StringBuffer sb = new StringBuffer();
                    if (reader != null) {
                        int read;
                        while ((read = reader.read(ary)) != -1) {
                            sb.append(ary, 0, read);
                        }
                        reader.close();
                    }
                    result_fragment.appendChild(this.document.createTextNode(sb.toString()));
                }
            } else if (parse.equals("xml")) {
                if (this.debug) {
                    System.err.println("Parse type is XML");
                }
                if (object instanceof Reader) {
                    input = new InputSource((Reader)object);
                } else if (object instanceof InputStream) {
                    input = new InputSource((InputStream)object);
                } else {
                    throw new Exception("Unknown object type: " + object);
                }
                Document included_document = null;
                try {
                    included_document = XIncludeProcessor.this.parser.parse((InputSource)input, false);
                }
                catch (Exception exception) {}
                if (suffix.startsWith("xpointer(") && suffix.endsWith(")")) {
                    String xpath = suffix.substring(9, suffix.length() - 1);
                    if (this.debug) {
                        System.err.println("XPath is " + xpath);
                    }
                    NodeList list = XPathAPI.selectNodeList(included_document, xpath);
                    int length = list.getLength();
                    if (this.debug) {
                        System.err.println("Found " + length + " nodes");
                    }
                    int i = 0;
                    while (i < length) {
                        result_fragment.appendChild(this.document.importNode(list.item(i), true));
                        ++i;
                    }
                } else {
                    result_fragment.appendChild(this.document.importNode(included_document.getDocumentElement(), true));
                }
            }
            Node parent_node = element.getParentNode();
            parent_node.replaceChild(result_fragment, element);
        }

        void startXMLBaseAttribute(String value) throws MalformedURLException {
            if (this.current_xmlbase_uri != null) {
                this.xmlbase_stack.push(this.current_xmlbase_uri);
            }
            this.current_xmlbase_uri = new URL(value);
        }
    }
}

