/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public abstract class BaseMarkupSerializer
implements ContentHandler,
DocumentHandler,
LexicalHandler,
DTDHandler,
DeclHandler,
DOMSerializer,
Serializer {
    private int _lastPrintable = 126;
    protected OutputFormat _format;
    protected Writer _writer;
    private StringBuffer _line;
    private StringBuffer _text;
    private int _spaces;
    private int _thisIndent;
    private int _nextIndent;
    protected IOException _exception;
    private ElementState[] _elementStates = new ElementState[10];
    private int _elementStateCount;
    private Vector _preRoot;
    protected boolean _started;
    private StringWriter _dtdWriter;
    private Writer _docWriter;
    protected Hashtable _prefixes;
    protected String _docTypePublicId;
    protected String _docTypeSystemId;

    protected BaseMarkupSerializer() {
        int n = 0;
        while (n < this._elementStates.length) {
            this._elementStates[n] = new ElementState();
            ++n;
        }
    }

    public ContentHandler asContentHandler() {
        return this;
    }

    public DOMSerializer asDOMSerializer() {
        return this;
    }

    public DocumentHandler asDocumentHandler() {
        return this;
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) {
        this.enterDTD();
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append("<!ATTLIST ").append(string).append(' ');
        stringBuffer.append(string2).append(' ').append(string3);
        if (string4 != null) {
            stringBuffer.append(' ').append(string4);
        }
        if (string5 != null) {
            stringBuffer.append(" \"").append(this.escape(string5)).append('\"');
        }
        stringBuffer.append('>');
        this.printText(stringBuffer.toString());
        if (this._format.getIndenting()) {
            this.breakLine();
        }
    }

    protected final void breakLine() {
        this.breakLine(false);
    }

    protected final void breakLine(boolean bl) {
        block4: {
            if (this._text.length() > 0) {
                while (this._spaces > 0) {
                    this._line.append(' ');
                    --this._spaces;
                }
                this._line.append((Object)this._text);
                this._text = new StringBuffer(20);
            }
            this.flushLine(bl);
            try {
                this._writer.write(this._format.getLineSeparator());
            }
            catch (IOException iOException) {
                if (this._exception != null) break block4;
                this._exception = iOException;
            }
        }
    }

    protected void characters(String string, boolean bl) {
        ElementState elementState = this.content();
        if (elementState != null) {
            boolean bl2 = bl = bl || elementState.unescaped;
        }
        if (elementState != null && (elementState.inCData || elementState.doCData)) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            if (!elementState.inCData) {
                stringBuffer.append("<![CDATA[");
                elementState.inCData = true;
            }
            int n = string.indexOf("]]>");
            while (n >= 0) {
                stringBuffer.append(string.substring(0, n + 2)).append("]]><![CDATA[");
                string = string.substring(n + 2);
                n = string.indexOf("]]>");
            }
            stringBuffer.append(string);
            int n2 = this._nextIndent;
            this._nextIndent = 0;
            this.printText(stringBuffer, true);
            this._nextIndent = n2;
        } else if (bl) {
            int n = this._nextIndent;
            this._nextIndent = 0;
            this.printText(string, true);
            this._nextIndent = n;
        } else if (elementState != null && elementState.preserveSpace) {
            int n = this._nextIndent;
            this._nextIndent = 0;
            this.printText(this.escape(string), true);
            this._nextIndent = n;
        } else {
            this.printText(this.escape(string), false);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        this.characters(new String(cArray, n, n2), false);
    }

    public void comment(String string) {
        ElementState elementState = this.content();
        StringBuffer stringBuffer = new StringBuffer(40);
        int n = string.indexOf("-->");
        if (n >= 0) {
            stringBuffer.append("<!--").append(string.substring(0, n)).append("-->");
        } else {
            stringBuffer.append("<!--").append(string).append("-->");
        }
        if (elementState == null) {
            if (this._preRoot == null) {
                this._preRoot = new Vector();
            }
            this._preRoot.addElement(stringBuffer.toString());
        } else {
            this.indent();
            this.printText(stringBuffer, false);
            this.unindent();
        }
    }

    public void comment(char[] cArray, int n, int n2) {
        this.comment(new String(cArray, n, n2));
    }

    protected ElementState content() {
        ElementState elementState = this.getElementState();
        if (elementState != null) {
            if (elementState.inCData && !elementState.doCData) {
                this.printText("]]>");
                elementState.inCData = false;
            }
            if (elementState.empty) {
                this.printText(">");
                elementState.empty = false;
            }
            elementState.afterElement = false;
        }
        return elementState;
    }

    public void elementDecl(String string, String string2) {
        this.enterDTD();
        this.printText("<!ELEMENT " + string + " " + string2 + ">");
        if (this._format.getIndenting()) {
            this.breakLine();
        }
    }

    public void endCDATA() {
        ElementState elementState = this.getElementState();
        if (elementState != null) {
            elementState.doCData = false;
        }
    }

    public void endDTD() {
    }

    public void endDocument() throws SAXException {
        this.serializePreRoot();
        this.flush();
        if (this._exception != null) {
            throw new SAXException(this._exception);
        }
    }

    public abstract void endElement(String var1) throws SAXException;

    public abstract void endElement(String var1, String var2, String var3) throws SAXException;

    public void endEntity(String string) {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    protected void enterDTD() {
        if (this._dtdWriter == null) {
            this._line.append((Object)this._text);
            this._text = new StringBuffer(20);
            this.flushLine(false);
            this._dtdWriter = new StringWriter();
            this._docWriter = this._writer;
            this._writer = this._dtdWriter;
        }
    }

    protected ElementState enterElementState(String string, String string2, String string3, boolean bl) {
        if (this._elementStateCount == this._elementStates.length) {
            ElementState[] elementStateArray = new ElementState[this._elementStates.length + 5];
            int n = 0;
            while (n < this._elementStates.length) {
                elementStateArray[n] = this._elementStates[n];
                ++n;
            }
            this._elementStates = elementStateArray;
            int n2 = this._elementStateCount;
            while (n2 < this._elementStates.length) {
                this._elementStates[n2] = new ElementState();
                ++n2;
            }
        }
        ElementState elementState = this._elementStates[this._elementStateCount];
        elementState.namespaceURI = string;
        elementState.localName = string2;
        elementState.rawName = string3;
        elementState.preserveSpace = bl;
        elementState.empty = true;
        elementState.afterElement = false;
        elementState.inCData = false;
        elementState.doCData = false;
        elementState.prefixes = this._prefixes;
        this._prefixes = null;
        ++this._elementStateCount;
        return elementState;
    }

    protected String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < ' ' && c != '\t' && c != '\n' && c != '\r' || c > this._lastPrintable || c == '\u00f7') {
                stringBuffer.append("&#").append(Integer.toString(c)).append(';');
            } else {
                String string2 = this.getEntityRef(c);
                if (string2 == null) {
                    stringBuffer.append(c);
                } else {
                    stringBuffer.append('&').append(string2).append(';');
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void externalEntityDecl(String string, String string2, String string3) {
        this.enterDTD();
        this.unparsedEntityDecl(string, string2, string3, null);
    }

    public void flush() {
        block3: {
            if (this._line.length() > 0 || this._text.length() > 0) {
                this.breakLine();
            }
            try {
                this._writer.flush();
            }
            catch (IOException iOException) {
                if (this._exception != null) break block3;
                this._exception = iOException;
            }
        }
    }

    private void flushLine(boolean bl) {
        block5: {
            if (this._line.length() <= 0) break block5;
            try {
                if (this._format.getIndenting() && !bl) {
                    int n = this._thisIndent;
                    if (2 * n > this._format.getLineWidth() && this._format.getLineWidth() > 0) {
                        n = this._format.getLineWidth() / 2;
                    }
                    while (n > 0) {
                        this._writer.write(32);
                        --n;
                    }
                }
                this._thisIndent = this._nextIndent;
                this._spaces = 0;
                this._writer.write(this._line.toString());
                this._line = new StringBuffer(40);
            }
            catch (IOException iOException) {
                if (this._exception != null) break block5;
                this._exception = iOException;
            }
        }
    }

    protected ElementState getElementState() {
        if (this._elementStateCount == 0) {
            return null;
        }
        return this._elementStates[this._elementStateCount - 1];
    }

    protected abstract String getEntityRef(char var1);

    protected String getPrefix(String string) {
        String string2;
        if (this._prefixes != null && (string2 = (String)this._prefixes.get(string)) != null) {
            return string2;
        }
        if (this._elementStateCount == 0) {
            return null;
        }
        int n = this._elementStateCount;
        while (n-- > 0) {
            if (this._elementStates[n].prefixes == null || (string2 = (String)this._elementStates[n].prefixes.get(string)) == null) continue;
            return string2;
        }
        return null;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.content();
        if (this._format.getIndenting()) {
            this._thisIndent = 0;
            int n3 = n;
            while (n2-- > 0) {
                if (cArray[n3] == '\n' || cArray[n3] == '\r') {
                    this.breakLine(true);
                } else {
                    this._text.append(cArray[n3]);
                }
                ++n3;
            }
        }
    }

    protected void indent() {
        this._nextIndent += this._format.getIndent();
    }

    public void internalEntityDecl(String string, String string2) {
        this.enterDTD();
        this.printText("<!ENTITY " + string + " \"" + this.escape(string2) + "\">");
        if (this._format.getIndenting()) {
            this.breakLine();
        }
    }

    protected String leaveDTD() {
        if (this._writer == this._dtdWriter) {
            this._line.append((Object)this._text);
            this._text = new StringBuffer(20);
            this.flushLine(false);
            this._writer = this._docWriter;
            return this._dtdWriter.toString();
        }
        return null;
    }

    protected ElementState leaveElementState() {
        if (this._elementStateCount > 1) {
            --this._elementStateCount;
            this._prefixes = this._elementStates[this._elementStateCount].prefixes;
            return this._elementStates[this._elementStateCount - 1];
        }
        if (this._elementStateCount == 1) {
            --this._elementStateCount;
            this._prefixes = this._elementStates[this._elementStateCount].prefixes;
            return null;
        }
        return null;
    }

    public void notationDecl(String string, String string2, String string3) {
        this.enterDTD();
        if (string2 != null) {
            this.printText("<!NOTATION " + string + " PUBLIC ");
            this.printDoctypeURL(string2);
            if (string3 != null) {
                this.printText("  ");
                this.printDoctypeURL(string3);
            }
        } else {
            this.printText("<!NOTATION " + string + " SYSTEM ");
            this.printDoctypeURL(string3);
        }
        this.printText(">");
        if (this._format.getIndenting()) {
            this.breakLine();
        }
    }

    protected void printDoctypeURL(String string) {
        this._text.append('\"');
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\"' || string.charAt(n) < ' ' || string.charAt(n) > '\u007f') {
                this._text.append("%").append(Integer.toHexString(string.charAt(n)));
            } else {
                this._text.append(string.charAt(n));
            }
            ++n;
        }
        this._text.append('\"');
    }

    protected final void printSpace() {
        if (this._text.length() > 0) {
            block5: {
                if (this._format.getLineWidth() > 0 && this._thisIndent + this._line.length() + this._spaces + this._text.length() > this._format.getLineWidth()) {
                    this.flushLine(false);
                    try {
                        this._writer.write(this._format.getLineSeparator());
                    }
                    catch (IOException iOException) {
                        if (this._exception != null) break block5;
                        this._exception = iOException;
                    }
                }
            }
            while (this._spaces > 0) {
                this._line.append(' ');
                --this._spaces;
            }
            this._line.append((Object)this._text);
            this._text = new StringBuffer(20);
        }
        ++this._spaces;
    }

    protected final void printText(String string) {
        this._text.append(string);
    }

    protected final void printText(String string, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '\n' || c == '\r') {
                    this.breakLine(true);
                } else {
                    this._text.append(c);
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == ' ' || c == '\f' || c == '\t' || c == '\n' || c == '\r') {
                    this.printSpace();
                } else {
                    this._text.append(c);
                }
                ++n;
            }
        }
    }

    protected final void printText(StringBuffer stringBuffer, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < stringBuffer.length()) {
                char c = stringBuffer.charAt(n);
                if (c == '\n' || c == '\r') {
                    this.breakLine(true);
                } else {
                    this._text.append(c);
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < stringBuffer.length()) {
                char c = stringBuffer.charAt(n);
                if (c == ' ' || c == '\f' || c == '\t' || c == '\n' || c == '\r') {
                    this.printSpace();
                } else {
                    this._text.append(c);
                }
                ++n;
            }
        }
    }

    protected final void printText(char[] cArray, int n, int n2) {
        this._text.append(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) {
        ElementState elementState = this.content();
        StringBuffer stringBuffer = new StringBuffer(40);
        int n = string.indexOf("?>");
        if (n >= 0) {
            stringBuffer.append("<?").append(string.substring(0, n));
        } else {
            stringBuffer.append("<?").append(string);
        }
        if (string2 != null) {
            stringBuffer.append(' ');
            n = string2.indexOf("?>");
            if (n >= 0) {
                stringBuffer.append(string2.substring(0, n));
            } else {
                stringBuffer.append(string2);
            }
        }
        stringBuffer.append("?>");
        if (elementState == null) {
            if (this._preRoot == null) {
                this._preRoot = new Vector();
            }
            this._preRoot.addElement(stringBuffer.toString());
        } else {
            this.indent();
            this.printText(stringBuffer, true);
            this.unindent();
        }
    }

    protected void reset() {
        this._line = new StringBuffer(80);
        this._text = new StringBuffer(20);
        this._spaces = 0;
        this._nextIndent = 0;
        this._thisIndent = 0;
        this._exception = null;
        this._elementStateCount = 0;
        this._started = false;
        this._dtdWriter = null;
        this._docTypePublicId = this._format.getDoctypePublic();
        this._docTypeSystemId = this._format.getDoctypeSystem();
    }

    public void serialize(Document document) throws IOException {
        if (this._writer == null) {
            throw new IllegalStateException("SER002 No writer supplied for serializer");
        }
        try {
            this.startDocument();
        }
        catch (SAXException sAXException) {}
        this.serializeNode(document);
        this.serializePreRoot();
        this.flush();
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void serialize(DocumentFragment documentFragment) throws IOException {
        if (this._writer == null) {
            throw new IllegalStateException("SER002 No writer supplied for serializer");
        }
        try {
            this.startDocument();
        }
        catch (SAXException sAXException) {}
        this.serializeNode(documentFragment);
        this.flush();
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void serialize(Element element) throws IOException {
        if (this._writer == null) {
            throw new IllegalStateException("SER002 No writer supplied for serializer");
        }
        try {
            this.startDocument();
        }
        catch (SAXException sAXException) {}
        this.serializeNode(element);
        this.flush();
        if (this._exception != null) {
            throw this._exception;
        }
    }

    protected abstract void serializeElement(Element var1);

    protected void serializeNode(Node node) {
        switch (node.getNodeType()) {
            case 3: {
                this.characters(node.getNodeValue(), false);
                break;
            }
            case 4: {
                this.startCDATA();
                this.characters(node.getNodeValue(), false);
                this.endCDATA();
                break;
            }
            case 8: {
                this.comment(node.getNodeValue());
                break;
            }
            case 5: {
                this.endCDATA();
                this.content();
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    this.serializeNode(node2);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 7: {
                this.processingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 1: {
                this.serializeElement((Element)node);
                break;
            }
            case 9: {
                Object object;
                DocumentType documentType = ((Document)node).getDoctype();
                DOMImplementation dOMImplementation = ((Document)node).getImplementation();
                if (documentType != null && dOMImplementation.hasFeature("XML", "2.0")) {
                    this.startDTD(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
                    object = documentType.getInternalSubset();
                    if (object != null && ((String)object).length() > 0) {
                        this.printText((String)object, true);
                    }
                    this.endDTD();
                }
            }
            case 11: {
                Object object = node.getFirstChild();
                while (object != null) {
                    this.serializeNode((Node)object);
                    object = object.getNextSibling();
                }
                break;
            }
        }
    }

    protected void serializePreRoot() {
        if (this._preRoot != null) {
            int n = 0;
            while (n < this._preRoot.size()) {
                this.printText((String)this._preRoot.elementAt(n), true);
                this.breakLine();
                ++n;
            }
            this._preRoot.removeAllElements();
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setOutputByteStream(OutputStream outputStream) throws UnsupportedEncodingException {
        if (this._format.getEncoding() == null) {
            this.setOutputCharStream(new OutputStreamWriter(outputStream));
        } else {
            this.setOutputCharStream(new OutputStreamWriter(outputStream, this._format.getEncoding()));
        }
    }

    public void setOutputCharStream(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("SER001 Argument 'output' is null.");
        }
        this._writer = writer;
        this.reset();
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        if (outputFormat == null) {
            throw new NullPointerException("SER001 Argument 'format' is null.");
        }
        this._format = outputFormat;
        this._lastPrintable = this._format.getLastPrintable();
        this.reset();
    }

    public void skippedEntity(String string) throws SAXException {
        this.endCDATA();
        this.content();
        this.printText("&" + string + ";");
    }

    public void startCDATA() {
        ElementState elementState = this.getElementState();
        if (elementState != null) {
            elementState.doCData = true;
        }
    }

    public void startDTD(String string, String string2, String string3) {
        this.enterDTD();
        this._docTypePublicId = string2;
        this._docTypeSystemId = string3;
    }

    public abstract void startDocument() throws SAXException;

    public abstract void startElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

    public abstract void startElement(String var1, AttributeList var2) throws SAXException;

    public void startEntity(String string) {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this._prefixes == null) {
            this._prefixes = new Hashtable();
        }
        this._prefixes.put(string2, string == null ? "" : string);
    }

    protected void unindent() {
        this._nextIndent -= this._format.getIndent();
        if (this._nextIndent < 0) {
            this._nextIndent = 0;
        }
        if (this._line.length() + this._spaces + this._text.length() == 0) {
            this._thisIndent = this._nextIndent;
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        this.enterDTD();
        if (string2 == null) {
            this.printText("<!ENTITY " + string + " SYSTEM ");
            this.printDoctypeURL(string3);
        } else {
            this.printText("<!ENTITY " + string + " PUBLIC ");
            this.printDoctypeURL(string2);
            this.printText(" ");
            this.printDoctypeURL(string3);
        }
        if (string4 != null) {
            this.printText(" NDATA " + string4);
        }
        this.printText(">");
        if (this._format.getIndenting()) {
            this.breakLine();
        }
    }
}

