/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;

public class TableRow
extends FObj {
    FontState fs;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    ColorType backgroundColor;
    int widthOfCellsSoFar = 0;
    int largestCellHeight = 0;
    Vector columns;
    BlockArea blockArea;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public TableRow(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table-row";
    }

    public void setColumns(Vector vector) {
        this.columns = vector;
    }

    public Status layout(Area area) throws FOPException {
        int n;
        Object object;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            String string = this.properties.get("font-family").getString();
            String string2 = this.properties.get("font-style").getString();
            object = this.properties.get("font-weight").getString();
            n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), string, string2, (String)object, n);
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.backgroundColor = this.properties.get("background-color").getColorType();
            if (area instanceof BlockArea) {
                area.end();
            }
            this.marker = 0;
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        this.blockArea = new BlockArea(this.fs, area.getAllocationWidth(), area.spaceLeft(), this.startIndent, this.endIndent, 0, 0, 0, 0);
        this.blockArea.setPage(area.getPage());
        this.blockArea.setBackgroundColor(this.backgroundColor);
        this.blockArea.start();
        int n2 = this.children.size();
        if (n2 != this.columns.size()) {
            System.err.println("WARNING: Number of children under table-row not equal to number of table-columns");
            return new Status(1);
        }
        this.widthOfCellsSoFar = 0;
        this.largestCellHeight = 0;
        int n3 = this.marker;
        while (n3 < n2) {
            object = (TableCell)this.children.elementAt(n3);
            ((TableCell)object).setStartOffset(this.widthOfCellsSoFar);
            n = ((TableColumn)this.columns.elementAt(n3)).getColumnWidth();
            ((TableCell)object).setWidth(n);
            this.widthOfCellsSoFar += n;
            Status status = ((TableCell)object).layout(this.blockArea);
            if (status.isIncomplete()) {
                this.marker = n3;
                if (n3 != 0 && status.getCode() == 2) {
                    status = new Status(3);
                }
                area.addChild(this.blockArea);
                area.increaseHeight(this.blockArea.getHeight());
                return status;
            }
            int n4 = ((TableCell)object).getHeight();
            this.blockArea.addDisplaySpace(-n4);
            if (n4 > this.largestCellHeight) {
                this.largestCellHeight = n4;
            }
            ++n3;
        }
        this.blockArea.end();
        area.addChild(this.blockArea);
        area.addDisplaySpace(this.largestCellHeight);
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        return new Status(1);
    }

    public int getAreaHeight() {
        return this.blockArea.getHeight();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new TableRow(fObj, propertyList);
        }
    }
}

