/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.Flow;
import org.apache.fop.fo.flow.StaticContent;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.fo.pagination.SequenceSpecification;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.PageMaster;
import org.apache.fop.layout.PageMasterFactory;

public class PageSequence
extends FObj {
    protected Root root;
    protected SequenceSpecification sequenceSpecification;
    protected Flow flow;
    protected StaticContent staticBefore;
    protected StaticContent staticAfter;
    protected LayoutMasterSet layoutMasterSet;
    protected Page currentPage;
    protected int currentPageNumber = 0;

    public static FObj.Maker maker() {
        return new Maker();
    }

    protected PageSequence(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:page-sequence";
        if (!fObj.getName().equals("fo:root")) {
            throw new FOPException("page-sequence must be child of root, not " + fObj.getName());
        }
        this.root = (Root)fObj;
        this.root.addPageSequence(this);
        this.layoutMasterSet = this.root.getLayoutMasterSet();
    }

    protected Page makePage(AreaTree areaTree) throws FOPException {
        if (this.sequenceSpecification == null) {
            throw new FOPException("page-sequence is missing an sequence-specification");
        }
        PageMasterFactory pageMasterFactory = this.sequenceSpecification.getFirstPageMasterFactory();
        PageMaster pageMaster = pageMasterFactory.getNextPageMaster();
        while (pageMaster == null) {
            if ((pageMasterFactory = pageMasterFactory.getNext()) == null) {
                throw new FOPException("out of sequence specifiers (FOP will eventually allow this)");
            }
            pageMaster = pageMasterFactory.getNextPageMaster();
        }
        return pageMaster.makePage(areaTree);
    }

    public void format(AreaTree areaTree) throws FOPException {
        Status status = new Status(1);
        do {
            AreaContainer areaContainer;
            this.currentPage = this.makePage(areaTree);
            this.currentPage.setNumber(++this.currentPageNumber);
            System.err.print(" [" + this.currentPageNumber);
            if (this.staticBefore != null && this.currentPage.getBefore() != null) {
                areaContainer = this.currentPage.getBefore();
                this.staticBefore.layout(areaContainer);
            }
            if (this.staticAfter != null && this.currentPage.getAfter() != null) {
                areaContainer = this.currentPage.getAfter();
                this.staticAfter.layout(areaContainer);
            }
            if (!(status.getCode() == 5 && this.currentPageNumber % 2 == 1 || status.getCode() == 6 && this.currentPageNumber % 2 == 0)) {
                areaContainer = this.currentPage.getBody();
                status = this.flow.layout(areaContainer);
            }
            System.err.print("]");
            areaTree.addPage(this.currentPage);
        } while (status.isIncomplete());
        System.err.println();
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    protected void setSequenceSpecification(SequenceSpecification sequenceSpecification) {
        this.sequenceSpecification = sequenceSpecification;
        sequenceSpecification.setLayoutMasterSet(this.layoutMasterSet);
    }

    public void setStaticContent(String string, StaticContent staticContent) {
        if (string.equals("xsl-before")) {
            this.staticBefore = staticContent;
        } else if (string.equals("xsl-after")) {
            this.staticAfter = staticContent;
        } else {
            System.err.println("WARNING: this version of FOP only supports static-content in region-before and region-after");
        }
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new PageSequence(fObj, propertyList);
        }
    }
}

