/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;
import java.net.URL;
import java.util.Hashtable;
import org.apache.fop.image.FopImage;

public class GifJpegImage
implements FopImage {
    int X;
    int Y;
    int width;
    int height;
    int pixelwidth;
    int pixelheight;
    String ref;
    boolean color = true;
    int bitperpixel = 8;
    int[] imagemap;
    int[] tempmap;
    protected Integer imageWait = new Integer(0);

    public GifJpegImage(String string, int n, int n2, int n3, int n4) {
        this.ref = string;
        this.X = n;
        this.Y = n2;
        this.pixelheight = -1;
        this.pixelwidth = -1;
        try {
            URL uRL = new URL(string);
            ImageProducer imageProducer = (ImageProducer)uRL.getContent();
            FopImageConsumer fopImageConsumer = new FopImageConsumer(this);
            imageProducer.startProduction(fopImageConsumer);
            Integer n5 = this.imageWait;
            synchronized (n5) {
                this.imageWait.wait();
            }
            this.tempmap = new int[this.pixelwidth * this.pixelheight];
            PixelGrabber pixelGrabber = new PixelGrabber(imageProducer, 0, 0, this.pixelwidth, this.pixelheight, this.tempmap, 0, n3);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Image grabbing interrupted");
            }
        }
        catch (ClassCastException classCastException) {
            System.err.println("Image format not supported: " + string);
        }
        catch (Exception exception) {
            System.err.println("Error loading image " + string + " : " + exception);
        }
        this.width = n3 == 0 ? this.pixelwidth * 1000 : n3;
        this.height = n4 == 0 ? this.pixelheight * 1000 : n4;
    }

    public String gethref() {
        return this.ref;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getpixelwidth() {
        return this.pixelwidth;
    }

    public int getpixelheight() {
        return this.pixelheight;
    }

    public int getX() {
        return this.X;
    }

    public int getY() {
        return this.Y;
    }

    public int[] getimagemap() {
        this.imagemap = new int[this.pixelheight * this.pixelwidth * 3];
        int n = 0;
        int n2 = 0;
        while (n2 < this.pixelheight * this.pixelwidth) {
            int n3 = this.tempmap[n2] >> 16 & 0xFF;
            int n4 = this.tempmap[n2] >> 8 & 0xFF;
            int n5 = this.tempmap[n2] & 0xFF;
            this.imagemap[n++] = n3;
            this.imagemap[n++] = n4;
            this.imagemap[n++] = n5;
            ++n2;
        }
        return this.imagemap;
    }

    public boolean getcolor() {
        return true;
    }

    public int getbitperpixel() {
        return this.bitperpixel;
    }

    public static class FopImageConsumer
    implements ImageConsumer {
        int width = -1;
        int height = -1;
        GifJpegImage graphic;

        public FopImageConsumer(GifJpegImage gifJpegImage) {
            this.graphic = gifJpegImage;
        }

        public void imageComplete(int n) {
            Integer n2 = this.graphic.imageWait;
            synchronized (n2) {
                this.graphic.imageWait.notifyAll();
            }
        }

        public void setColorModel(ColorModel colorModel) {
        }

        public void setDimensions(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        public void setHints(int n) {
        }

        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        }

        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        }

        public void setProperties(Hashtable hashtable) {
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

