/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.layout.AreaContainer;

public class LinkSet {
    String externalDestination;
    Vector rects = new Vector();
    int xoffset = 0;
    int yoffset = 0;

    public LinkSet(String string) {
        this.externalDestination = string;
    }

    public void addRect(Rectangle rectangle) {
        rectangle.y = this.yoffset;
        this.rects.addElement(rectangle);
    }

    public void setYOffset(int n) {
        this.yoffset = n;
    }

    public void applyAreaContainerOffsets(AreaContainer areaContainer) {
        Enumeration enumeration = this.rects.elements();
        while (enumeration.hasMoreElements()) {
            Rectangle rectangle = (Rectangle)enumeration.nextElement();
            rectangle.x += areaContainer.getXPosition();
            rectangle.y = areaContainer.getYPosition() - areaContainer.getHeight() - rectangle.y;
        }
    }

    public void mergeLinks() {
        int n = this.rects.size();
        if (n == 1) {
            return;
        }
        Rectangle rectangle = new Rectangle((Rectangle)this.rects.elementAt(0));
        Vector<Rectangle> vector = new Vector<Rectangle>();
        int n2 = 1;
        while (n2 < n) {
            Rectangle rectangle2 = (Rectangle)this.rects.elementAt(n2);
            if (rectangle2.y != rectangle.y || rectangle.height != rectangle2.height) {
                vector.addElement(rectangle);
                rectangle = new Rectangle(rectangle2);
            } else {
                rectangle.width = rectangle2.x + rectangle2.width - rectangle.x;
            }
            if (n2 == n - 1) {
                vector.addElement(rectangle);
            }
            ++n2;
        }
        this.rects = vector;
    }

    public String getDest() {
        return this.externalDestination;
    }

    public Vector getRects() {
        return this.rects;
    }
}

