/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Parser;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ProjectHelper {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void configure(Project project, Object target, NamedNodeMap nodeMap) throws BuildException {
        BeanInfo beanInfo;
        if (target instanceof TaskAdapter) {
            target = ((TaskAdapter)target).getProxy();
        }
        Hashtable<String, Method> propertySetters = new Hashtable<String, Method>();
        try {
            beanInfo = Introspector.getBeanInfo(target.getClass());
        }
        catch (IntrospectionException introspectionException) {
            String msg = "Can't introspect class: " + target.getClass();
            throw new BuildException(msg);
        }
        PropertyDescriptor[] pda = beanInfo.getPropertyDescriptors();
        int i = 0;
        while (i < pda.length) {
            Class<?> c;
            Class<?>[] ma;
            PropertyDescriptor pd = pda[i];
            String property = pd.getName();
            Method setMethod = pd.getWriteMethod();
            if (setMethod != null && (ma = setMethod.getParameterTypes()).length == 1 && (c = ma[0]).getName().equals("java.lang.String")) {
                propertySetters.put(property, setMethod);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < nodeMap.getLength()) {
            Node node = nodeMap.item(i2);
            if (node.getNodeType() == 2) {
                Attr attr = (Attr)node;
                Method setMethod = (Method)propertySetters.get(attr.getName());
                if (setMethod == null) {
                    if (!attr.getName().equals("id")) {
                        String msg = "Configuration property \"" + attr.getName() + "\" does not have a setMethod in " + target.getClass();
                        throw new BuildException(msg);
                    }
                    project.addReference(attr.getValue(), target);
                } else {
                    String value = ProjectHelper.replaceProperties(attr.getValue(), project.getProperties());
                    try {
                        setMethod.invoke(target, (Object[])new String[]{value});
                    }
                    catch (IllegalAccessException iae) {
                        String msg = "Error setting value for attrib: " + attr.getName();
                        iae.printStackTrace();
                        throw new BuildException(msg);
                    }
                    catch (InvocationTargetException ie) {
                        String msg = "Error setting value for attrib: " + attr.getName() + " in " + target.getClass().getName();
                        ie.printStackTrace();
                        ie.getTargetException().printStackTrace();
                        throw new BuildException(msg);
                    }
                }
            }
            ++i2;
        }
    }

    public static void configureProject(Project project, File buildFile) throws BuildException {
        String baseDir;
        String id;
        Document doc;
        try {
            doc = Parser.getParser(project).parse(buildFile);
        }
        catch (IOException ioe) {
            String msg = "Can't open config file: " + buildFile + " due to: " + ioe;
            throw new BuildException(msg);
        }
        catch (SAXException se) {
            String msg = "Can't open config file: " + buildFile + " due to: " + se;
            throw new BuildException(msg);
        }
        Element root = doc.getDocumentElement();
        if (!root.getTagName().equals("project")) {
            String msg = "Config file is not of expected XML type";
            throw new BuildException(msg);
        }
        project.setDefaultTarget(root.getAttribute("default"));
        String name = root.getAttribute("name");
        project.setName(name);
        if (name != null) {
            project.addReference(name, project);
        }
        if ((id = root.getAttribute("id")) != null) {
            project.addReference(id, project);
        }
        if ((baseDir = project.getProperty("basedir")) == null && (baseDir = root.getAttribute("basedir")).equals("")) {
            baseDir = new File(buildFile.getAbsolutePath()).getParent();
        }
        project.setBasedir(baseDir);
        ProjectHelper.configureTargets(project, root);
    }

    private static void configureTargets(Project project, Element root) throws BuildException {
        NodeList list = root.getElementsByTagName("target");
        int i = 0;
        while (i < list.getLength()) {
            Element element = (Element)list.item(i);
            String targetName = element.getAttribute("name");
            String targetDep = element.getAttribute("depends");
            String targetCond = element.getAttribute("if");
            String targetId = element.getAttribute("id");
            if (targetName.equals("")) {
                String msg = "target element appears without a name attribute";
                throw new BuildException(msg);
            }
            Target target = new Target();
            target.setName(targetName);
            target.setCondition(targetCond);
            project.addTarget(targetName, target);
            if (targetId != null && !targetId.equals("")) {
                project.addReference(targetId, target);
            }
            if (targetDep.length() > 0) {
                StringTokenizer tok = new StringTokenizer(targetDep, ",", false);
                while (tok.hasMoreTokens()) {
                    target.addDependency(tok.nextToken().trim());
                }
            }
            ProjectHelper.configureTasks(project, target, element);
            ++i;
        }
    }

    private static void configureTasks(Project project, Target target, Element targetElement) throws BuildException {
        NodeList list = targetElement.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String taskType = element.getTagName();
                Task task = project.createTask(taskType);
                NamedNodeMap nodeMap = element.getAttributes();
                ProjectHelper.configure(project, task, nodeMap);
                task.init();
                task.setTarget(target);
                target.addTask(task);
                ProjectHelper.processNestedProperties(project, task, element);
            }
            ++i;
        }
    }

    private static void processNestedProperties(Project project, Object target, Element targetElement) throws BuildException {
        Class<?> targetClass = target.getClass();
        NodeList list = targetElement.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 3) {
                String text = ((Text)node).getData();
                try {
                    Method addProp = targetClass.getMethod("addText", "".getClass());
                    Object child = addProp.invoke(target, text);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (text.trim().length() > 0) {
                        throw new BuildException(String.valueOf(String.valueOf(targetClass)) + " does not support nested text elements");
                    }
                }
                catch (InvocationTargetException ite) {
                    throw new BuildException(ite.getMessage());
                }
                catch (IllegalAccessException iae) {
                    throw new BuildException(iae.getMessage());
                }
            }
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String propType = element.getTagName();
                String methodName = "create" + Character.toUpperCase(propType.charAt(0)) + propType.substring(1);
                try {
                    Method addProp = targetClass.getMethod(methodName, new Class[0]);
                    Object child = addProp.invoke(target, new Object[0]);
                    NamedNodeMap nodeMap = element.getAttributes();
                    ProjectHelper.configure(project, child, nodeMap);
                    ProjectHelper.processNestedProperties(project, child, element);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new BuildException(String.valueOf(String.valueOf(targetClass)) + " does not support nested " + propType + " properties");
                }
                catch (InvocationTargetException ite) {
                    throw new BuildException(ite.getMessage());
                }
                catch (IllegalAccessException iae) {
                    throw new BuildException(iae.getMessage());
                }
            }
            ++i;
        }
    }

    public static String replaceProperties(String value, Hashtable keys) throws BuildException {
        int pos;
        StringBuffer sb = new StringBuffer();
        boolean i = false;
        int prev = 0;
        while ((pos = value.indexOf("$", prev)) >= 0) {
            if (pos > 0) {
                sb.append(value.substring(prev, pos));
            }
            if (value.charAt(pos + 1) != '{') {
                sb.append(value.charAt(pos + 1));
                prev = pos + 2;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName < 0) {
                throw new BuildException("Syntax error in prop: " + value);
            }
            String n = value.substring(pos + 2, endName);
            String v = (String)keys.get(n);
            sb.append(v);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            sb.append(value.substring(prev));
        }
        return sb.toString();
    }
}

