/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Deltree
extends Task {
    private File dir;

    public void execute() throws BuildException {
        this.project.log("Deleting: " + this.dir.getAbsolutePath());
        if (this.dir.exists()) {
            if (!this.dir.isDirectory()) {
                this.dir.delete();
                return;
            }
            try {
                this.removeDir(this.dir);
            }
            catch (IOException iOException) {
                String msg = "Unable to delete " + this.dir.getAbsolutePath();
                throw new BuildException(msg);
            }
        }
    }

    private void removeDir(File dir) throws IOException {
        String[] list = dir.list();
        int i = 0;
        while (i < list.length) {
            String s = list[i];
            File f = new File(dir, s);
            if (f.isDirectory()) {
                this.removeDir(f);
            } else {
                f.delete();
            }
            ++i;
        }
        dir.delete();
    }

    public void setDir(String dirName) {
        this.dir = this.project.resolveFile(dirName);
    }
}

