/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Zip;

public class Jar
extends Zip {
    private File manifest;

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        zOut.setMethod(8);
        if (this.manifest != null) {
            ZipEntry ze = new ZipEntry("META-INF/");
            zOut.putNextEntry(ze);
            super.zipFile(this.manifest, zOut, "META-INF/MANIFEST.MF");
        } else {
            ZipEntry ze = new ZipEntry("META-INF/");
            zOut.putNextEntry(ze);
            String s = "/org/apache/tools/ant/defaultManifest.mf";
            InputStream in = this.getClass().getResourceAsStream(s);
            if (in == null) {
                throw new BuildException("Could not find: " + s);
            }
            this.zipFile(in, zOut, "META-INF/MANIFEST.MF");
        }
    }

    public void setJarfile(String jarFilename) {
        super.setZipfile(jarFilename);
        this.archiveType = "jar";
    }

    public void setManifest(String manifestFilename) {
        this.manifest = this.project.resolveFile(manifestFilename);
    }

    protected void zipDir(File dir, ZipOutputStream zOut, String vPath) throws IOException {
        if (!vPath.equals("META-INF/")) {
            ZipEntry ze = new ZipEntry(vPath);
            zOut.putNextEntry(ze);
        }
    }

    protected void zipFile(File file, ZipOutputStream zOut, String vPath) throws IOException {
        if (!vPath.equals("META-INF/MANIFEST.MF")) {
            super.zipFile(file, zOut, vPath);
        }
    }
}

