/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public abstract class MatchingTask
extends Task {
    protected Vector includeList = new Vector();
    protected Vector excludeList = new Vector();
    protected boolean useDefaultExcludes = true;

    public NameEntry createExclude() {
        NameEntry result = new NameEntry();
        this.excludeList.addElement(result);
        return result;
    }

    public NameEntry createInclude() {
        NameEntry result = new NameEntry();
        this.includeList.addElement(result);
        return result;
    }

    protected DirectoryScanner getDirectoryScanner(File baseDir) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(baseDir);
        ds.setIncludes(this.makeArray(this.includeList));
        ds.setExcludes(this.makeArray(this.excludeList));
        if (this.useDefaultExcludes) {
            ds.addDefaultExcludes();
        }
        ds.scan();
        return ds;
    }

    protected String getProperty(String name) {
        return this.project.getProperty(name);
    }

    private String[] makeArray(Vector list) {
        if (list.size() == 0) {
            return null;
        }
        Vector<String> tmpNames = new Vector<String>();
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            String includes = ((NameEntry)e.nextElement()).getName();
            if (includes == null) continue;
            StringTokenizer tok = new StringTokenizer(includes, ", ", false);
            while (tok.hasMoreTokens()) {
                String pattern = tok.nextToken().trim();
                if (pattern.length() <= 0) continue;
                tmpNames.addElement(pattern);
            }
        }
        String[] result = new String[tmpNames.size()];
        int i = 0;
        while (i < tmpNames.size()) {
            result[i] = (String)tmpNames.elementAt(i);
            ++i;
        }
        return result;
    }

    public void setDefaultexcludes(String useDefaultExcludes) {
        this.useDefaultExcludes = Project.toBoolean(useDefaultExcludes);
    }

    public void setExcludes(String excludes) {
        if (excludes != null && excludes.length() > 0) {
            this.createExclude().setName(excludes);
        }
    }

    public void setIgnore(String ignoreString) {
        this.project.log("The ignore attribute is deprecated.Please use the excludes attribute.", 1);
        if (ignoreString != null && ignoreString.length() > 0) {
            Vector tmpExcludes = new Vector();
            StringTokenizer tok = new StringTokenizer(ignoreString, ", ", false);
            while (tok.hasMoreTokens()) {
                this.createExclude().setName("**/" + tok.nextToken().trim() + "/**");
            }
        }
    }

    public void setIncludes(String includes) {
        if (includes != null && includes.length() > 0) {
            this.createInclude().setName(includes);
        }
    }

    public void setItems(String itemString) {
        this.project.log("The items attribute is deprecated. Please use the includes attribute.", 1);
        if (itemString == null || itemString.equals("*") || itemString.equals(".")) {
            this.createInclude().setName("**");
        } else {
            StringTokenizer tok = new StringTokenizer(itemString, ", ");
            while (tok.hasMoreTokens()) {
                String pattern = tok.nextToken().trim();
                if (pattern.length() <= 0) continue;
                this.createInclude().setName(String.valueOf(pattern) + "/**");
            }
        }
    }

    public class NameEntry {
        private boolean valid = true;
        private String name;

        public String getName() {
            return this.valid ? this.name : null;
        }

        public void setIf(String name) {
            if (MatchingTask.this.getProperty(name) == null) {
                this.valid = false;
            }
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUnless(String name) {
            if (MatchingTask.this.getProperty(name) != null) {
                this.valid = false;
            }
        }
    }
}

