/*
 * Decompiled with CFR 0.152.
 */
package dom;

import dom.DOMParserWrapper;
import org.apache.xerces.dom.TextImpl;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMCount {
    private static final String DEFAULT_PARSER_NAME = "dom.wrappers.DOMParser";
    private long elements;
    private long attributes;
    private long characters;
    private long ignorableWhitespace;

    public static void count(String string, String string2) {
        try {
            DOMParserWrapper dOMParserWrapper = (DOMParserWrapper)Class.forName(string).newInstance();
            DOMCount dOMCount = new DOMCount();
            long l = System.currentTimeMillis();
            Document document = dOMParserWrapper.parse(string2);
            dOMCount.traverse(document);
            long l2 = System.currentTimeMillis();
            dOMCount.printResults(string2, l2 - l);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                sAXException.getException().printStackTrace(System.err);
            } else {
                sAXException.printStackTrace(System.err);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        if (var0.length == 0) {
            DOMCount.printUsage();
            System.exit(1);
        }
        var1_1 = "dom.wrappers.DOMParser";
        var2_2 = 0;
        while (var2_2 < var0.length) {
            var3_3 = var0[var2_2];
            if (!var3_3.startsWith("-")) ** GOTO lbl18
            if (var3_3.equals("-p")) {
                if (var2_2 == var0.length - 1) {
                    System.err.println("error: missing parser name");
                    System.exit(1);
                }
                var1_1 = var0[++var2_2];
            } else {
                if (var3_3.equals("-h")) {
                    DOMCount.printUsage();
                    System.exit(1);
                }
lbl18:
                // 4 sources

                DOMCount.count(var1_1, var3_3);
            }
            ++var2_2;
        }
    }

    public void printResults(String string, long l) {
        System.out.print(string);
        System.out.print(": ");
        System.out.print(l);
        System.out.print(" ms (");
        System.out.print(this.elements);
        System.out.print(" elems, ");
        System.out.print(this.attributes);
        System.out.print(" attrs, ");
        System.out.print(this.ignorableWhitespace);
        System.out.print(" spaces, ");
        System.out.print(this.characters);
        System.out.print(" chars)");
        System.out.println();
    }

    private static void printUsage() {
        System.err.println("usage: java dom.DOMCount (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name  Specify DOM parser wrapper by name.");
        System.err.println("           Default parser: dom.wrappers.DOMParser");
        System.err.println("  -h       This help screen.");
    }

    public void traverse(Node node) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                this.elements = 0L;
                this.attributes = 0L;
                this.characters = 0L;
                this.ignorableWhitespace = 0L;
                this.traverse(((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                NodeList nodeList;
                ++this.elements;
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    this.attributes += (long)namedNodeMap.getLength();
                }
                if ((nodeList = node.getChildNodes()) == null) break;
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    this.traverse(nodeList.item(n2));
                    ++n2;
                }
                break;
            }
            case 5: {
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = nodeList.getLength();
                int n3 = 0;
                while (n3 < n) {
                    this.traverse(nodeList.item(n3));
                    ++n3;
                }
                break;
            }
            case 4: {
                this.characters += (long)node.getNodeValue().length();
                break;
            }
            case 3: {
                if (node instanceof TextImpl) {
                    if (((TextImpl)node).isIgnorableWhitespace()) {
                        this.ignorableWhitespace += (long)node.getNodeValue().length();
                        break;
                    }
                    this.characters += (long)node.getNodeValue().length();
                    break;
                }
                this.characters += (long)node.getNodeValue().length();
                break;
            }
        }
    }
}

