/*
 * Decompiled with CFR 0.152.
 */
package dom.traversal;

import dom.traversal.NameNodeFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import ui.DOMTreeFull;

public class TreeWalkerView
extends JFrame
implements ActionListener {
    Document document;
    TreeNode lastSelected;
    DOMParser parser;
    JTextArea messageText;
    JScrollPane messageScroll;
    DOMTreeFull jtree;
    TreeWalker treeWalker;
    NameNodeFilter nameNodeFilter;
    JButton nextButton;
    JButton prevButton;
    JButton removeButton;
    JButton addButton;
    JTextField addText;
    JButton newIterator;
    JList whatToShow;
    JCheckBox match;
    JTextField nameFilter;
    JButton parentButton;
    JButton nextSiblingButton;
    JButton previousSiblingButton;
    JButton firstChildButton;
    JButton lastChildButton;
    JButton currentButton;
    String[] whatArray = new String[]{"ALL", "ELEMENT", "ATTRIBUTE", "TEXT", "CDATA_SECTION", "ENTITY_REFERENCE", "ENTITY", "PROCESSING_INSTRUCTION", "COMMENT", "DOCUMENT", "DOCUMENT_TYPE", "DOCUMENT_FRAGMENT", "NOTATION"};
    JCheckBox expandERs;
    Hashtable treeNodeMap = new Hashtable();

    public TreeWalkerView(String string) {
        super("TreeWalkerView: " + string);
        try {
            this.parser = new DOMParser();
            this.parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", true);
            this.parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            Errors errors = new Errors();
            this.parser.setErrorHandler((ErrorHandler)errors);
            this.parser.parse(string);
            this.document = this.parser.getDocument();
            if (!this.document.supports("Traversal", "2.0")) {
                throw new RuntimeException("This DOM Document does not support Traversal");
            }
            this.jtree = new DOMTreeFull(this.document);
            this.jtree.getSelectionModel().setSelectionMode(1);
            this.jtree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    TreePath treePath = treeSelectionEvent.getPath();
                    TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                    if (TreeWalkerView.this.jtree.getSelectionModel().isPathSelected(treePath)) {
                        TreeWalkerView.this.nodeSelected(treeNode);
                    }
                }
            });
            BorderLayout borderLayout = new BorderLayout();
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Document Order Traversal"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            this.prevButton = new JButton("Previous");
            jPanel.add(this.prevButton);
            this.prevButton.addActionListener(this);
            this.nextButton = new JButton("Next");
            jPanel.add(this.nextButton);
            this.nextButton.addActionListener(this);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Walk"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            this.parentButton = new JButton("Parent");
            jPanel2.add((Component)this.parentButton, "North");
            this.parentButton.addActionListener(this);
            JPanel jPanel3 = new JPanel();
            this.firstChildButton = new JButton("First Child");
            jPanel3.add(this.firstChildButton);
            this.firstChildButton.addActionListener(this);
            this.lastChildButton = new JButton("Last Child");
            jPanel3.add(this.lastChildButton);
            this.lastChildButton.addActionListener(this);
            jPanel2.add((Component)jPanel3, "South");
            this.nextSiblingButton = new JButton("Next Sibling");
            jPanel2.add((Component)this.nextSiblingButton, "East");
            this.nextSiblingButton.addActionListener(this);
            this.previousSiblingButton = new JButton("Previous Sibling");
            jPanel2.add((Component)this.previousSiblingButton, "West");
            this.previousSiblingButton.addActionListener(this);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Selected Node"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            JPanel jPanel5 = new JPanel();
            this.currentButton = new JButton("Current");
            jPanel5.add(this.currentButton);
            this.currentButton.addActionListener(this);
            this.removeButton = new JButton("Remove");
            jPanel5.add(this.removeButton);
            this.removeButton.addActionListener(this);
            this.addButton = new JButton("Append Text");
            this.addText = new JTextField(10);
            jPanel5.add(this.addButton);
            jPanel4.add((Component)jPanel5, "North");
            jPanel4.add((Component)this.addText, "Center");
            this.addButton.addActionListener(this);
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BorderLayout());
            jPanel6.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Filter Settings"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout(new BorderLayout());
            this.newIterator = new JButton("createTreeWalker");
            jPanel7.add((Component)this.newIterator, "North");
            this.expandERs = new JCheckBox("expandEntityReferences");
            this.expandERs.setSelected(true);
            jPanel7.add((Component)this.expandERs, "South");
            jPanel6.add((Component)jPanel7, "North");
            this.newIterator.addActionListener(this);
            JPanel jPanel8 = new JPanel();
            jPanel8.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("whatToShow"), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
            this.whatToShow = new JList<String>(this.whatArray);
            JScrollPane jScrollPane = new JScrollPane(this.whatToShow){

                public Dimension getPreferredSize() {
                    return new Dimension(200, 65);
                }
            };
            jPanel8.add(jScrollPane);
            JPanel jPanel9 = new JPanel();
            jPanel9.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("NodeNameFilter"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            jPanel9.setLayout(new BorderLayout());
            this.match = new JCheckBox("match/ignore node name", true);
            this.nameFilter = new JTextField(10);
            jPanel9.add((Component)this.match, "North");
            jPanel9.add((Component)this.nameFilter, "South");
            jPanel6.add((Component)jPanel7, "North");
            jPanel6.add((Component)jPanel8, "Center");
            jPanel6.add((Component)jPanel9, "South");
            this.whatToShow.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                }
            });
            JPanel jPanel10 = new JPanel(new BorderLayout());
            jPanel10.setFont(new Font("Dialog", 0, 8));
            JPanel jPanel11 = new JPanel(new BorderLayout());
            jPanel11.add((Component)jPanel, "North");
            jPanel11.add((Component)jPanel2, "Center");
            jPanel11.add((Component)jPanel4, "South");
            jPanel10.add((Component)jPanel11, "North");
            jPanel10.add((Component)jPanel6, "Center");
            jPanel10.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Controls"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            JPanel jPanel12 = new JPanel(new BorderLayout());
            JScrollPane jScrollPane2 = new JScrollPane(this.jtree);
            jScrollPane2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Tree View"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            this.messageText = new JTextArea(3, 5);
            JPanel jPanel13 = new JPanel(new BorderLayout());
            this.messageScroll = new JScrollPane(this.messageText);
            jPanel13.add(this.messageScroll);
            jPanel13.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Messages"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            JPanel jPanel14 = new JPanel();
            jPanel14.setLayout(new BorderLayout());
            jPanel14.add((Component)jPanel10, "East");
            jPanel14.add((Component)jScrollPane2, "Center");
            jPanel14.add((Component)jPanel13, "South");
            this.getContentPane().add(jPanel14);
            Hashtable hashtable = errors.getErrorNodes();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                this.messageText.append((String)enumeration.nextElement());
            }
            boolean bl = this.expandERs.isSelected();
            this.treeWalker = ((DocumentTraversal)((Object)this.document)).createTreeWalker(this.document, -1, new NameNodeFilter(), bl);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.newIterator) {
            TreeNode treeNode = (TreeNode)this.jtree.getLastSelectedPathComponent();
            if (treeNode == null) {
                this.messageText.append("Must select a tree component.");
                return;
            }
            Node node = this.jtree.getNode(treeNode);
            if (node == null) {
                this.setMessage("No current Node in TreeNode: " + node);
            }
            int[] nArray = this.whatToShow.getSelectedIndices();
            int n = 0;
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] == 0) {
                    n = 65535;
                    break;
                }
                n |= 1 << nArray[n2] - 1;
                ++n2;
            }
            String string = this.nameFilter.getText();
            boolean bl = this.match.isSelected();
            if (this.nameNodeFilter == null) {
                this.nameNodeFilter = new NameNodeFilter();
            }
            if (string.equals("")) {
                this.setMessage("NodeNameFilter name is \"\". Assuming null.");
                string = null;
            }
            this.nameNodeFilter.setName(string);
            this.nameNodeFilter.setMatch(bl);
            boolean bl2 = this.expandERs.isSelected();
            this.treeWalker = ((DocumentTraversal)((Object)this.document)).createTreeWalker(node, n, this.nameNodeFilter, bl2);
            this.setMessage("createTreeWalker: root=" + node + ", whatToShow=" + n + ", match=" + bl + ", name=" + string);
            return;
        }
        if (actionEvent.getSource() == this.currentButton) {
            TreeNode treeNode = (TreeNode)this.jtree.getLastSelectedPathComponent();
            if (treeNode == null) {
                this.messageText.append("Must select a tree component.");
                return;
            }
            Node node = this.jtree.getNode(treeNode);
            if (node == null) {
                this.setMessage("No current Node in TreeNode: " + node);
            }
            this.treeWalker.setCurrentNode(node);
            return;
        }
        if (actionEvent.getSource() == this.addButton) {
            String string = this.addText.getText();
            if (string == null) {
                return;
            }
            TreeNode treeNode = (TreeNode)this.jtree.getLastSelectedPathComponent();
            if (treeNode == null) {
                this.messageText.append("Must select a tree component to add a child to it.");
                return;
            }
            TreePath treePath = new TreePath(((DefaultTreeModel)this.jtree.getModel()).getPathToRoot(treeNode));
            if (treePath == null) {
                this.setMessage("Could not create a path.");
                return;
            }
            if (!this.jtree.getSelectionModel().isPathSelected(treePath)) {
                return;
            }
            Node node = this.jtree.getNode(treeNode);
            Text text = this.document.createTextNode(string);
            try {
                node.appendChild(text);
            }
            catch (DOMException dOMException) {
                this.setMessage("DOMException:" + dOMException.code + ", " + dOMException);
                return;
            }
            ((DOMTreeFull.Model)this.jtree.getModel()).insertNode(text, (MutableTreeNode)treeNode);
            return;
        }
        if (actionEvent.getSource() == this.removeButton) {
            TreeNode treeNode = (TreeNode)this.jtree.getLastSelectedPathComponent();
            if (treeNode == null) {
                this.messageText.append("Must select a tree component to remove it.");
                return;
            }
            TreePath treePath = new TreePath(((DefaultTreeModel)this.jtree.getModel()).getPathToRoot(treeNode));
            if (treePath == null) {
                this.setMessage("Could not create a path.");
                return;
            }
            if (!this.jtree.getSelectionModel().isPathSelected(treePath)) {
                return;
            }
            Node node = this.jtree.getNode(treeNode);
            if (node == null) {
                return;
            }
            Node node2 = node.getParentNode();
            if (node2 == null) {
                return;
            }
            node2.removeChild(node);
            ((DefaultTreeModel)this.jtree.getModel()).removeNodeFromParent((MutableTreeNode)treeNode);
            return;
        }
        if (actionEvent.getSource() == this.previousSiblingButton) {
            Node node = this.treeWalker.previousSibling();
            this.handleButton(node, "previousSibling()");
            return;
        }
        if (actionEvent.getSource() == this.firstChildButton) {
            Node node = this.treeWalker.firstChild();
            this.handleButton(node, "firstChild()");
            return;
        }
        if (actionEvent.getSource() == this.lastChildButton) {
            Node node = this.treeWalker.lastChild();
            this.handleButton(node, "lastChild()");
            return;
        }
        if (actionEvent.getSource() == this.nextSiblingButton) {
            Node node = this.treeWalker.nextSibling();
            this.handleButton(node, "nextSibling()");
            return;
        }
        if (actionEvent.getSource() == this.parentButton) {
            Node node = this.treeWalker.parentNode();
            this.handleButton(node, "parentNode()");
            return;
        }
        if (actionEvent.getSource() == this.nextButton) {
            Node node = this.treeWalker.nextNode();
            this.handleButton(node, "nextNode()");
            return;
        }
        if (actionEvent.getSource() == this.prevButton) {
            Node node = this.treeWalker.previousNode();
            this.handleButton(node, "previousNode()");
            return;
        }
    }

    void expandTree() {
        int n = 0;
        while (n < this.jtree.getRowCount()) {
            this.jtree.expandRow(n);
            ++n;
        }
    }

    void handleButton(Node node, String string) {
        this.setMessage("treeWalker." + string + " == " + node);
        if (node == null) {
            return;
        }
        TreeNode treeNode = this.jtree.getTreeNode(node);
        if (treeNode == null) {
            this.setMessage("No JTree TreeNode for Node name:" + node.getNodeName());
            return;
        }
        TreePath treePath = new TreePath(((DefaultTreeModel)this.jtree.getModel()).getPathToRoot(treeNode));
        this.jtree.requestFocus();
        this.jtree.setSelectionPath(treePath);
        this.jtree.scrollPathToVisible(treePath);
    }

    public static void main(String[] stringArray) {
        block2: {
            if (stringArray.length <= 0) break block2;
            String string = stringArray[0];
            try {
                TreeWalkerView treeWalkerView = new TreeWalkerView(string);
                treeWalkerView.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                ((Component)treeWalkerView).setSize(640, 700);
                ((Component)treeWalkerView).setVisible(true);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    void nodeSelected(TreeNode treeNode) {
        this.lastSelected = treeNode;
        Node node = this.jtree.getNode(treeNode);
        if (node == null) {
            return;
        }
        this.setMessage(DOMTreeFull.toString(node));
    }

    void setMessage(String string) {
        this.messageText.selectAll();
        this.messageText.cut();
        this.messageText.append(string);
        this.messageText.setCaretPosition(0);
    }

    class Errors
    implements ErrorHandler {
        Hashtable errorNodes = new Hashtable();

        Errors() {
        }

        public void clearErrors() {
            this.errorNodes.clear();
        }

        public void error(SAXParseException sAXParseException) {
            this.store(sAXParseException, "[Error]");
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.store(sAXParseException, "[Fatal Error]");
        }

        public Object getError(Node node) {
            return this.errorNodes.get(node);
        }

        public Hashtable getErrorNodes() {
            return this.errorNodes;
        }

        void store(SAXParseException sAXParseException, String string) {
            String string2 = String.valueOf(string) + " at line number, " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage() + "\n";
            Node node = null;
            try {
                node = (Node)TreeWalkerView.this.parser.getProperty("http://apache.org/xml/properties/dom-node");
            }
            catch (SAXException sAXException) {
                System.err.println(sAXException.getMessage());
                return;
            }
            if (node == null) {
                return;
            }
            String string3 = (String)this.errorNodes.get(node);
            if (string3 != null) {
                this.errorNodes.put(node, String.valueOf(string3) + string2);
            } else {
                this.errorNodes.put(node, string2);
            }
        }

        public void warning(SAXParseException sAXParseException) {
            this.store(sAXParseException, "[Warning]");
        }
    }
}

